/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public interface MapModel<V>
extends Map<String, V> {
    public Map<String, V> getMap();

    public void setMap(Map<String, V> var1);

    default public <T> T invokeFunction(Function<Map<String, V>, T> function) {
        Map<String, V> map = this.getMap();
        if (map == null) {
            map = new LinkedHashMap<String, V>();
            this.setMap(map);
        }
        return function.apply(map);
    }

    default public void invoke(Consumer<Map<String, V>> function) {
        Map<String, V> map = this.getMap();
        if (map == null) {
            map = new LinkedHashMap<String, V>();
            this.setMap(map);
        }
        function.accept(map);
    }

    @Override
    default public int size() {
        return this.invokeFunction(Map::size);
    }

    @Override
    default public boolean isEmpty() {
        return this.invokeFunction(Map::isEmpty);
    }

    @Override
    default public boolean containsValue(Object value) {
        return this.invokeFunction(map -> map.containsValue(value));
    }

    @Override
    default public void clear() {
        this.invoke(Map::clear);
    }

    @Override
    default public Set<String> keySet() {
        return this.invokeFunction(Map::keySet);
    }

    @Override
    default public Collection<V> values() {
        return this.invokeFunction(Map::values);
    }

    @Override
    default public Set<Map.Entry<String, V>> entrySet() {
        return this.invokeFunction(Map::entrySet);
    }

    @Override
    default public V get(Object key) {
        return (V)this.invokeFunction(map -> map.get(key));
    }

    @Override
    default public boolean containsKey(Object key) {
        return this.invokeFunction(map -> map.containsKey(key));
    }

    @Override
    default public V put(String key, V value) {
        return (V)this.invokeFunction(map -> map.put(key, value));
    }

    @Override
    default public void putAll(Map<? extends String, ? extends V> m) {
        this.invoke(map -> map.putAll(m));
    }

    @Override
    default public V remove(Object key) {
        return (V)this.invokeFunction(map -> map.remove(key));
    }
}

