package io.smallrye.openapi.runtime.scanner.dataobject;

import java.util.Locale;
import java.io.Serializable;
import java.lang.RuntimeException;
import java.lang.Throwable;
import java.lang.String;
import java.util.Arrays;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;

/**
 * Warning this class consists of generated code.
 */
public class DataObjectMessages_$bundle implements DataObjectMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected DataObjectMessages_$bundle() {}
    public static final DataObjectMessages_$bundle INSTANCE = new DataObjectMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String notNull$str() {
        return "SROAP07000: Input parameter can not be null";
    }
    @Override
    public final RuntimeException notNull() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), notNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidPropertyNamingStrategy$str() {
        return "SROAP07001: Invalid property-naming-strategy: %s";
    }
    @Override
    public final OpenApiRuntimeException invalidPropertyNamingStrategy(final String configValue) {
        final OpenApiRuntimeException result = new OpenApiRuntimeException(String.format(getLoggingLocale(), invalidPropertyNamingStrategy$str(), configValue));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPropertyNamingStrategyWithCause$str() {
        return "SROAP07002: Exception accessing property-naming-strategy: %s";
    }
    @Override
    public final OpenApiRuntimeException invalidPropertyNamingStrategyWithCause(final String configValue, final Throwable cause) {
        final OpenApiRuntimeException result = new OpenApiRuntimeException(String.format(getLoggingLocale(), invalidPropertyNamingStrategyWithCause$str(), configValue), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
