package io.smallrye.openapi.internal.models.security;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-04-17T14:50:39.792713284Z")
public class OAuthFlow
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.security.OAuthFlow>
        implements org.eclipse.microprofile.openapi.models.security.OAuthFlow {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    public java.lang.String getAuthorizationUrl() {
        return getProperty("authorizationUrl", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setAuthorizationUrl(java.lang.String newValue) {
        setProperty("authorizationUrl", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.String getTokenUrl() {
        return getProperty("tokenUrl", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setTokenUrl(java.lang.String newValue) {
        setProperty("tokenUrl", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.String getRefreshUrl() {
        return getProperty("refreshUrl", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setRefreshUrl(java.lang.String newValue) {
        setProperty("refreshUrl", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, java.lang.String> getScopes() {
        return getMapProperty("scopes");
    }

    /** {@inheritDoc} */
    @Override
    public void setScopes(java.util.Map<String, java.lang.String> newValue) {
        setMapProperty("scopes", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public OAuthFlow addScope(String newKey, java.lang.String newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("scopes", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeScope(String key) {
        removeMapPropertyEntry("scopes", key);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(4);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(4);

        public Properties() {
            types.put("authorizationUrl", DataType.type(java.lang.String.class));
            minVersions.put("authorizationUrl", OpenApiVersion.V3_0);
            types.put("tokenUrl", DataType.type(java.lang.String.class));
            minVersions.put("tokenUrl", OpenApiVersion.V3_0);
            types.put("refreshUrl", DataType.type(java.lang.String.class));
            minVersions.put("refreshUrl", OpenApiVersion.V3_0);
            types.put("scopes", DataType.mapOf(DataType.type(java.lang.String.class)));
            minVersions.put("scopes", OpenApiVersion.V3_0);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
