package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.DataType;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2024-11-13T20:00:42.179107036Z")
public abstract class AbstractOpenAPI
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.OpenAPI>
        implements org.eclipse.microprofile.openapi.models.OpenAPI {

    /** {@inheritDoc} */
    @Override
    protected org.eclipse.microprofile.openapi.models.OpenAPI filter(org.eclipse.microprofile.openapi.OASFilter filter) {
        filter.filterOpenAPI(this);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.String getOpenapi() {
        return getProperty("openapi", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setOpenapi(java.lang.String newValue) {
        setProperty("openapi", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.info.Info getInfo() {
        return getProperty("info", org.eclipse.microprofile.openapi.models.info.Info.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setInfo(org.eclipse.microprofile.openapi.models.info.Info newValue) {
        setProperty("info", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.servers.Server> getServers() {
        return getListProperty("servers");
    }

    /** {@inheritDoc} */
    @Override
    public void setServers(java.util.List<org.eclipse.microprofile.openapi.models.servers.Server> newValue) {
        setListProperty("servers", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addServer(org.eclipse.microprofile.openapi.models.servers.Server newValue) {
        addListPropertyEntry("servers", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeServer(org.eclipse.microprofile.openapi.models.servers.Server value) {
        removeListPropertyEntry("servers", value);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> getSecurity() {
        return getListProperty("security");
    }

    /** {@inheritDoc} */
    @Override
    public void setSecurity(java.util.List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> newValue) {
        setListProperty("security", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addSecurityRequirement(org.eclipse.microprofile.openapi.models.security.SecurityRequirement newValue) {
        addListPropertyEntry("security", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeSecurityRequirement(org.eclipse.microprofile.openapi.models.security.SecurityRequirement value) {
        removeListPropertyEntry("security", value);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.tags.Tag> getTags() {
        return getListProperty("tags");
    }

    /** {@inheritDoc} */
    @Override
    public void setTags(java.util.List<org.eclipse.microprofile.openapi.models.tags.Tag> newValue) {
        setListProperty("tags", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addTag(org.eclipse.microprofile.openapi.models.tags.Tag newValue) {
        addListPropertyEntry("tags", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeTag(org.eclipse.microprofile.openapi.models.tags.Tag value) {
        removeListPropertyEntry("tags", value);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.Paths getPaths() {
        return getProperty("paths", org.eclipse.microprofile.openapi.models.Paths.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setPaths(org.eclipse.microprofile.openapi.models.Paths newValue) {
        setProperty("paths", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> getWebhooks() {
        return getMapProperty("webhooks");
    }

    /** {@inheritDoc} */
    @Override
    public void setWebhooks(java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> newValue) {
        setMapProperty("webhooks", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addWebhook(String newKey, org.eclipse.microprofile.openapi.models.PathItem newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("webhooks", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeWebhook(String key) {
        removeMapPropertyEntry("webhooks", key);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.Components getComponents() {
        return getProperty("components", org.eclipse.microprofile.openapi.models.Components.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setComponents(org.eclipse.microprofile.openapi.models.Components newValue) {
        setProperty("components", newValue);
    }

    public static class Properties implements io.smallrye.openapi.internal.models.SmallRyeOASModels.Properties {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(9);

        public Properties() {
            types.put("openapi", DataType.type(java.lang.String.class));
            types.put("info", DataType.type(org.eclipse.microprofile.openapi.models.info.Info.class));
            types.put("externalDocs", DataType.type(org.eclipse.microprofile.openapi.models.ExternalDocumentation.class));
            types.put("servers", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.servers.Server.class)));
            types.put("security", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.security.SecurityRequirement.class)));
            types.put("tags", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.tags.Tag.class)));
            types.put("paths", DataType.type(org.eclipse.microprofile.openapi.models.Paths.class));
            types.put("webhooks", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.PathItem.class)));
            types.put("components", DataType.type(org.eclipse.microprofile.openapi.models.Components.class));
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }
    }
}
