/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.processor;

import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;

public class JavaSecurityProcessor {
    private final AnnotationScannerContext context;
    private String currentSecurityScheme;
    private List<OAuthFlow> currentFlows;
    private String[] resourceRolesAllowed;

    public void addRolesAllowedToScopes(String[] roles) {
        this.resourceRolesAllowed = roles;
        this.addScopes(roles);
    }

    public void addDeclaredRolesToScopes(String[] roles) {
        this.addScopes(roles);
    }

    public void processSecurityRoles(MethodInfo method, Operation operation) {
        this.processSecurityRolesForMethodOperation(method, operation);
    }

    public JavaSecurityProcessor(AnnotationScannerContext context) {
        this.context = context;
    }

    public void initialize(OpenAPI openApi) {
        this.currentSecurityScheme = null;
        this.currentFlows = null;
        this.resourceRolesAllowed = null;
        this.checkSecurityScheme(openApi);
    }

    private void addScopes(String[] roles) {
        if (roles == null || this.currentFlows == null) {
            return;
        }
        this.currentFlows.forEach(flow -> {
            if (flow.getScopes() == null) {
                flow.setScopes(new LinkedHashMap());
            }
            Arrays.stream(roles).forEach(role -> flow.addScope(role, role + " role"));
        });
    }

    private void processSecurityRolesForMethodOperation(MethodInfo method, Operation operation) {
        if (this.currentSecurityScheme != null) {
            String[] rolesAllowed = (String[])this.context.annotations().getAnnotationValue((AnnotationTarget)method, SecurityConstants.ROLES_ALLOWED);
            if (rolesAllowed != null) {
                this.addScopes(rolesAllowed);
                this.addRolesAllowed(operation, rolesAllowed);
            } else if (this.resourceRolesAllowed != null) {
                boolean permitAll;
                boolean denyAll = this.context.annotations().getAnnotation((AnnotationTarget)method, SecurityConstants.DENY_ALL) != null;
                boolean bl = permitAll = this.context.annotations().getAnnotation((AnnotationTarget)method, SecurityConstants.PERMIT_ALL) != null;
                if (denyAll) {
                    this.addRolesAllowed(operation, new String[0]);
                } else if (!permitAll) {
                    this.addRolesAllowed(operation, this.resourceRolesAllowed);
                }
            }
        }
    }

    private void addRolesAllowed(Operation operation, String[] roles) {
        SecurityRequirement requirement;
        List requirements = operation.getSecurity();
        if (requirements == null) {
            SecurityRequirement requirement2 = OASFactory.createSecurityRequirement();
            requirement2.addScheme(this.currentSecurityScheme, new ArrayList<String>(Arrays.asList(roles)));
            operation.setSecurity(new ArrayList<SecurityRequirement>(Arrays.asList(requirement2)));
        } else if (requirements.size() == 1 && (requirement = (SecurityRequirement)requirements.get(0)).hasScheme(this.currentSecurityScheme)) {
            List scopes = Stream.concat(requirement.getScheme(this.currentSecurityScheme).stream(), Arrays.stream(roles)).distinct().collect(Collectors.toList());
            requirement.addScheme(this.currentSecurityScheme, scopes);
        }
    }

    private void checkSecurityScheme(OpenAPI openApi) {
        Map.Entry scheme;
        SecurityScheme.Type schemeType;
        if (openApi.getComponents() == null) {
            return;
        }
        Map schemes = openApi.getComponents().getSecuritySchemes();
        if (schemes != null && schemes.size() == 1 && (schemeType = ((SecurityScheme)(scheme = schemes.entrySet().iterator().next()).getValue()).getType()) != null) {
            switch (schemeType) {
                case OAUTH2: 
                case OPENIDCONNECT: {
                    this.saveSecurityScheme((String)scheme.getKey(), (SecurityScheme)scheme.getValue());
                    break;
                }
            }
        }
    }

    private void saveSecurityScheme(String schemeName, SecurityScheme scheme) {
        this.currentSecurityScheme = schemeName;
        this.currentFlows = new ArrayList<OAuthFlow>();
        OAuthFlows flows = scheme.getFlows();
        if (flows != null) {
            this.saveFlow(flows.getAuthorizationCode());
            this.saveFlow(flows.getClientCredentials());
            this.saveFlow(flows.getImplicit());
            this.saveFlow(flows.getPassword());
        }
    }

    private void saveFlow(OAuthFlow flow) {
        if (flow != null && flow.getScopes() == null) {
            this.currentFlows.add(flow);
        }
    }
}

