/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.internal.models.media.SchemaSupport;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.Extensions;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;

public class SchemaIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Schema, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";

    public SchemaIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SCHEMA, Names.create(Schema.class));
    }

    @Override
    public Schema read(AnnotationInstance annotation) {
        return this.read((String)null, annotation);
    }

    @Override
    protected Schema read(String name, AnnotationInstance annotation) {
        Schema schema = OASFactory.createSchema();
        Extensions.setName((Extensible)schema, (String)name);
        return SchemaFactory.readSchema(this.scannerContext(), schema, annotation, Collections.emptyMap());
    }

    @Override
    public Schema readValue(V node) {
        if (node == null) {
            return null;
        }
        if (this.jsonIO().isBoolean(node)) {
            return OASFactory.createSchema().booleanSchema(this.jsonIO().asBoolean(node));
        }
        if (this.jsonIO().isObject(node)) {
            return this.readObject((O)this.jsonIO().asObject(node));
        }
        return null;
    }

    @Override
    public Schema readObject(O node) {
        IoLogging.logger.singleJsonObject("Schema");
        Schema schema = OASFactory.createSchema();
        Extensions.setName((Extensible)schema, (String)this.getName(node));
        schema.setRef(this.jsonIO().getJsonString(node, "$ref"));
        if (this.openApiVersion() == IOContext.OpenApiVersion.V3_1) {
            String dialect = this.jsonIO().getString(node, "$schema");
            if (dialect == null || dialect.equals("https://spec.openapis.org/oas/3.1/dialect/base") || dialect.equals("https://json-schema.org/draft/2020-12/schema")) {
                this.populateSchemaObject(schema, node);
            } else {
                Map properties = (Map)this.jsonIO().fromJson(node);
                properties.forEach((arg_0, arg_1) -> ((Schema)schema).set(arg_0, arg_1));
            }
        } else {
            this.populateSchemaObject30(schema, node);
        }
        return schema;
    }

    private void populateSchemaObject(Schema schema, O node) {
        Object typeNode = this.jsonIO().getValue(node, "type");
        if (typeNode != null) {
            if (this.jsonIO().isString(typeNode)) {
                ArrayList<Object> typeList = new ArrayList<Object>(2);
                typeList.add(this.readJson(typeNode, DataType.type(Schema.SchemaType.class)));
                schema.set("type", typeList);
            } else {
                schema.set("type", this.readJson(typeNode, DataType.listOf((DataType)DataType.type(Schema.SchemaType.class))));
            }
        }
        for (Map.Entry<String, DataType> entry : SchemaConstant.PROPERTIES_DATA_TYPES.entrySet()) {
            String key = entry.getKey();
            DataType type = entry.getValue();
            Object fieldNode = this.jsonIO().getValue(node, key);
            if (fieldNode == null) continue;
            schema.set(key, this.readJson(fieldNode, type));
        }
        for (Map.Entry<String, Object> entry : this.jsonIO().properties(node)) {
            String name = entry.getKey();
            Object fieldNode = entry.getValue();
            if (SchemaConstant.PROPERTIES_DATA_TYPES.containsKey(name) || name.equals("type") || name.equals(PROP_NAME) || name.equals("$ref")) continue;
            schema.set(name, this.jsonIO().fromJson(fieldNode));
        }
    }

    private void populateSchemaObject30(Schema schema, O node) {
        List enumeration;
        List allOfRefs;
        BigDecimal maximum;
        SchemaSupport.setType(schema, this.enumValue(this.jsonIO().getValue(node, "type"), Schema.SchemaType.class));
        SchemaSupport.setNullable(schema, this.jsonIO().getBoolean(node, "nullable"));
        BigDecimal minimum = this.jsonIO().getBigDecimal(node, "minimum");
        if (minimum != null) {
            if (this.jsonIO().getBoolean(node, "exclusiveMinimum") == Boolean.TRUE) {
                schema.setExclusiveMinimum(minimum);
            } else {
                schema.setMinimum(minimum);
            }
        }
        if ((maximum = this.jsonIO().getBigDecimal(node, "maximum")) != null) {
            if (this.jsonIO().getBoolean(node, "exclusiveMaximum") == Boolean.TRUE) {
                schema.setExclusiveMaximum(maximum);
            } else {
                schema.setMaximum(maximum);
            }
        }
        for (Map.Entry<String, DataType> entry : SchemaConstant.PROPERTIES_DATA_TYPES_3_0.entrySet()) {
            String key = entry.getKey();
            DataType dataType = entry.getValue();
            Object fieldNode = this.jsonIO().getValue(node, key);
            if (fieldNode == null) continue;
            schema.set(key, this.readJson(fieldNode, dataType));
        }
        this.extensionIO().readMap(node).forEach((arg_0, arg_1) -> ((Schema)schema).addExtension(arg_0, arg_1));
        List allOf = schema.getAllOf();
        if (schema.getRef() == null && allOf != null && (allOfRefs = allOf.stream().filter(s -> SchemaIO.isSoloRef(s)).collect(Collectors.toList())).size() == 1) {
            Schema refSchema = (Schema)allOfRefs.get(0);
            schema.removeAllOf(refSchema);
            schema.setRef(refSchema.getRef());
            if (schema.getAllOf().isEmpty()) {
                schema.setAllOf(null);
            }
        }
        if (schema.getRef() != null && schema.getType() == null && SchemaSupport.getNullable(schema) == Boolean.TRUE) {
            ArrayList<Schema> newAnyOfSchemas = new ArrayList<Schema>();
            newAnyOfSchemas.add((Schema)OASFactory.createSchema().ref(schema.getRef()));
            newAnyOfSchemas.add(SchemaSupport.nullSchema());
            if (schema.getAnyOf() == null || schema.getAnyOf().isEmpty()) {
                schema.setAnyOf(newAnyOfSchemas);
            } else {
                schema.addAllOf(OASFactory.createSchema().anyOf(newAnyOfSchemas));
            }
            schema.setRef(null);
            SchemaSupport.setNullable(schema, null);
        }
        if ((enumeration = schema.getEnumeration()) != null && enumeration.size() == 1) {
            if (enumeration.get(0) == null) {
                SchemaSupport.setType(schema, Schema.SchemaType.NULL);
                schema.setEnumeration(null);
            } else if (schema.getConstValue() == null) {
                schema.setConstValue(enumeration.get(0));
                schema.setEnumeration(null);
            }
        }
    }

    private String getName(O node) {
        Object name = this.jsonIO().getValue(node, PROP_NAME);
        if (this.jsonIO().isString(name)) {
            return this.jsonIO().asString(name);
        }
        return null;
    }

    @Override
    protected Object readJson(V node, DataType desiredType) {
        Object value = super.readJson(node, desiredType);
        if (value != null) {
            return value;
        }
        return this.jsonIO().fromJson(node);
    }

    @Override
    protected Object readValue(V node, Class<?> desiredType) {
        if (desiredType == Schema.class) {
            return this.readValue(node);
        }
        return super.readValue(node, desiredType);
    }

    @Override
    public Optional<? extends V> write(Schema model) {
        if (model == null) {
            return Optional.empty();
        }
        if (this.openApiVersion() == IOContext.OpenApiVersion.V3_1) {
            return this.write31(model);
        }
        return this.write30(model);
    }

    private Optional<? extends V> write31(Schema model) {
        if (model.getBooleanSchema() != null) {
            return this.jsonIO().toJson(model.getBooleanSchema());
        }
        return this.writeMap(model.getAll());
    }

    public Optional<O> write30(Schema model) {
        return this.optionalJsonObject(model).map(node -> {
            ReplacementFields fields = this.compute30ReplacementFields(model);
            if (fields.ref != null && !fields.ref.isEmpty()) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, "format", this.jsonIO().toJson(model.getFormat()));
                this.setIfPresent(node, "title", this.jsonIO().toJson(model.getTitle()));
                this.setIfPresent(node, "description", this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, "default", this.jsonIO().toJson(model.getDefaultValue()));
                this.setIfPresent(node, "multipleOf", this.jsonIO().toJson(model.getMultipleOf()));
                this.setIfPresent(node, "maximum", this.jsonIO().toJson(fields.maximum));
                this.setIfPresent(node, "exclusiveMaximum", this.jsonIO().toJson(fields.exclusiveMaximum));
                this.setIfPresent(node, "minimum", this.jsonIO().toJson(fields.minimum));
                this.setIfPresent(node, "exclusiveMinimum", this.jsonIO().toJson(fields.exclusiveMinimum));
                this.setIfPresent(node, "maxLength", this.jsonIO().toJson(model.getMaxLength()));
                this.setIfPresent(node, "minLength", this.jsonIO().toJson(model.getMinLength()));
                this.setIfPresent(node, "pattern", this.jsonIO().toJson(model.getPattern()));
                this.setIfPresent(node, "maxItems", this.jsonIO().toJson(model.getMaxItems()));
                this.setIfPresent(node, "minItems", this.jsonIO().toJson(model.getMinItems()));
                this.setIfPresent(node, "uniqueItems", this.jsonIO().toJson(model.getUniqueItems()));
                this.setIfPresent(node, "maxProperties", this.jsonIO().toJson(model.getMaxProperties()));
                this.setIfPresent(node, "minProperties", this.jsonIO().toJson(model.getMinProperties()));
                this.setIfPresent(node, "required", this.jsonIO().toJson(model.getRequired()));
                this.setIfPresent(node, "enum", this.jsonIO().toJson(fields.enumeration));
                this.setIfPresent(node, "type", this.jsonIO().toJson(fields.type));
                this.setIfPresent(node, "items", this.write(model.getItems()));
                this.setIfPresent(node, "allOf", this.writeList(fields.allOf));
                this.setIfPresent(node, "properties", this.writeMap(model.getProperties()));
                if (model.getAdditionalPropertiesBoolean() != null) {
                    this.setIfPresent(node, "additionalProperties", this.jsonIO().toJson(model.getAdditionalPropertiesBoolean()));
                } else {
                    this.setIfPresent(node, "additionalProperties", this.write(model.getAdditionalPropertiesSchema()));
                }
                this.setIfPresent(node, "readOnly", this.jsonIO().toJson(model.getReadOnly()));
                this.setIfPresent(node, "xml", this.jsonIO().toJson(model.getXml(), this));
                this.setIfPresent(node, "externalDocs", this.jsonIO().toJson(model.getExternalDocs(), this));
                this.setIfPresent(node, "example", this.jsonIO().toJson(fields.example));
                this.setIfPresent(node, "oneOf", this.writeList(model.getOneOf()));
                this.setIfPresent(node, "anyOf", this.writeList(fields.anyOf));
                this.setIfPresent(node, "not", this.write(model.getNot()));
                this.setIfPresent(node, "discriminator", this.jsonIO().toJson(model.getDiscriminator(), this));
                this.setIfPresent(node, "nullable", this.jsonIO().toJson(fields.nullable));
                this.setIfPresent(node, "writeOnly", this.jsonIO().toJson(model.getWriteOnly()));
                this.setIfPresent(node, "deprecated", this.jsonIO().toJson(model.getDeprecated()));
                this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    private ReplacementFields compute30ReplacementFields(Schema schema31) {
        ReplacementFields result = new ReplacementFields();
        result.type = SchemaSupport.getNonNullType(schema31);
        result.nullable = SchemaSupport.getNullable(schema31);
        result.enumeration = schema31.getEnumeration();
        if (result.type == null && result.nullable == Boolean.TRUE) {
            result.nullable = null;
            result.enumeration = Collections.singletonList(null);
        } else if (schema31.getConstValue() != null) {
            result.enumeration = Collections.singletonList(schema31.getConstValue());
        }
        BigDecimal oldMinimum = schema31.getMinimum();
        BigDecimal oldExclusiveMinimum = schema31.getExclusiveMinimum();
        if (oldMinimum != null) {
            result.minimum = oldMinimum;
            if (oldExclusiveMinimum != null && oldExclusiveMinimum.compareTo(oldMinimum) >= 0) {
                result.minimum = oldExclusiveMinimum;
                result.exclusiveMinimum = Boolean.TRUE;
            }
        } else if (oldExclusiveMinimum != null) {
            result.minimum = oldExclusiveMinimum;
            result.exclusiveMinimum = Boolean.TRUE;
        }
        BigDecimal oldMaximum = schema31.getMaximum();
        BigDecimal oldExclusiveMaximum = schema31.getExclusiveMaximum();
        if (oldMaximum != null) {
            result.maximum = oldMaximum;
            if (oldExclusiveMaximum != null && oldExclusiveMaximum.compareTo(oldMaximum) <= 0) {
                result.maximum = oldExclusiveMaximum;
                result.exclusiveMaximum = Boolean.TRUE;
            }
        } else if (oldExclusiveMaximum != null) {
            result.maximum = oldExclusiveMaximum;
            result.exclusiveMaximum = Boolean.TRUE;
        }
        result.example = schema31.getExample();
        if (result.example == null) {
            result.example = Optional.ofNullable(schema31.getExamples()).flatMap(l -> l.stream().findFirst()).orElse(null);
        }
        result.ref = schema31.getRef();
        result.allOf = schema31.getAllOf();
        result.anyOf = schema31.getAnyOf();
        if (result.ref != null && !SchemaIO.isSoloRef(schema31)) {
            result.ref = null;
            Schema refSchema = (Schema)OASFactory.createSchema().ref(schema31.getRef());
            result.allOf = ModelUtil.replace(result.allOf, ArrayList::new);
            result.allOf = ModelUtil.add(refSchema, result.allOf, ArrayList::new);
        }
        if (result.anyOf != null && result.anyOf.size() == 2 && result.ref == null && result.type == null) {
            Optional<Schema> typeNullSchema = result.anyOf.stream().filter(s -> SchemaIO.isSoloTypeNull(s)).findFirst();
            Optional<Schema> refSchema = result.anyOf.stream().filter(s -> SchemaIO.isSoloRef(s)).findFirst();
            if (typeNullSchema.isPresent() && refSchema.isPresent()) {
                result.anyOf = null;
                result.nullable = Boolean.TRUE;
                result.allOf = ModelUtil.replace(result.allOf, ArrayList::new);
                result.allOf = ModelUtil.add(refSchema.get(), result.allOf, ArrayList::new);
            }
        }
        return result;
    }

    private Optional<? extends V> writeObject(Object value) {
        if (value instanceof Schema) {
            return this.write((Schema)value);
        }
        return this.jsonIO().toJson(value, this);
    }

    private Optional<O> writeMap(Map<?, ?> map) {
        return this.optionalJsonObject(map).map(result -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("type".equals(key) && value instanceof List && ((List)value).size() == 1) {
                    value = ((List)value).get(0);
                }
                this.setIfPresent(result, key, this.writeObject(value));
            }
            return result;
        }).map(this.jsonIO()::buildObject);
    }

    private Optional<A> writeList(List<?> list) {
        return this.optionalJsonArray(list).map(result -> {
            for (Object entry : list) {
                this.writeObject(entry).ifPresent(v -> this.jsonIO().add(result, v));
            }
            return this.jsonIO().buildArray(result);
        });
    }

    private static boolean isSoloRef(Schema schema) {
        Map data = schema.getAll();
        return data.size() == 1 && data.containsKey("$ref");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSoloTypeNull(Schema schema) {
        Map data = schema.getAll();
        List types = schema.getType();
        if (data.size() != 1) return false;
        if (types == null) return false;
        if (!types.stream().anyMatch(arg_0 -> Schema.SchemaType.NULL.equals(arg_0))) return false;
        return true;
    }

    private static class ReplacementFields {
        private Schema.SchemaType type;
        private Boolean nullable;
        private BigDecimal minimum;
        private Boolean exclusiveMinimum;
        private BigDecimal maximum;
        private Boolean exclusiveMaximum;
        private Object example;
        private String ref;
        private List<Schema> allOf;
        private List<Schema> anyOf;
        private List<Object> enumeration;

        private ReplacementFields() {
        }
    }
}

