package io.smallrye.openapi.internal.models.responses;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-01-07T17:59:13.303661910Z")
public class APIResponse
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.responses.APIResponse>
        implements org.eclipse.microprofile.openapi.models.responses.APIResponse {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    protected org.eclipse.microprofile.openapi.models.responses.APIResponse filter(org.eclipse.microprofile.openapi.OASFilter filter) {
        return filter.filterAPIResponse(this);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.headers.Header> getHeaders() {
        return getMapProperty("headers");
    }

    /** {@inheritDoc} */
    @Override
    public void setHeaders(java.util.Map<String, org.eclipse.microprofile.openapi.models.headers.Header> newValue) {
        setMapProperty("headers", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public APIResponse addHeader(String newKey, org.eclipse.microprofile.openapi.models.headers.Header newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("headers", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeHeader(String key) {
        removeMapPropertyEntry("headers", key);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.media.Content getContent() {
        return getProperty("content", org.eclipse.microprofile.openapi.models.media.Content.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setContent(org.eclipse.microprofile.openapi.models.media.Content newValue) {
        setProperty("content", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.links.Link> getLinks() {
        return getMapProperty("links");
    }

    /** {@inheritDoc} */
    @Override
    public void setLinks(java.util.Map<String, org.eclipse.microprofile.openapi.models.links.Link> newValue) {
        setMapProperty("links", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public APIResponse addLink(String newKey, org.eclipse.microprofile.openapi.models.links.Link newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("links", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeLink(String key) {
        removeMapPropertyEntry("links", key);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(5);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(5);

        public Properties() {
            types.put("ref", DataType.type(java.lang.String.class));
            minVersions.put("ref", OpenApiVersion.V3_0);
            types.put("description", DataType.type(java.lang.String.class));
            minVersions.put("description", OpenApiVersion.V3_0);
            types.put("headers", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.headers.Header.class)));
            minVersions.put("headers", OpenApiVersion.V3_0);
            types.put("content", DataType.type(org.eclipse.microprofile.openapi.models.media.Content.class));
            minVersions.put("content", OpenApiVersion.V3_0);
            types.put("links", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.links.Link.class)));
            minVersions.put("links", OpenApiVersion.V3_0);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
