package io.smallrye.openapi.internal.models.servers;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-01-07T17:59:13.318737398Z")
public class Server
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.servers.Server>
        implements org.eclipse.microprofile.openapi.models.servers.Server {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    protected org.eclipse.microprofile.openapi.models.servers.Server filter(org.eclipse.microprofile.openapi.OASFilter filter) {
        return filter.filterServer(this);
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.String getUrl() {
        return getProperty("url", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setUrl(java.lang.String newValue) {
        setProperty("url", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.servers.ServerVariable> getVariables() {
        return getMapProperty("variables");
    }

    /** {@inheritDoc} */
    @Override
    public void setVariables(java.util.Map<String, org.eclipse.microprofile.openapi.models.servers.ServerVariable> newValue) {
        setMapProperty("variables", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Server addVariable(String newKey, org.eclipse.microprofile.openapi.models.servers.ServerVariable newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("variables", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeVariable(String key) {
        removeMapPropertyEntry("variables", key);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(3);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(3);

        public Properties() {
            types.put("url", DataType.type(java.lang.String.class));
            minVersions.put("url", OpenApiVersion.V3_0);
            types.put("description", DataType.type(java.lang.String.class));
            minVersions.put("description", OpenApiVersion.V3_0);
            types.put("variables", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.servers.ServerVariable.class)));
            minVersions.put("variables", OpenApiVersion.V3_0);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
