package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-01-22T21:29:40.199327549Z")
public abstract class AbstractOpenAPI
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.OpenAPI>
        implements org.eclipse.microprofile.openapi.models.OpenAPI {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    protected org.eclipse.microprofile.openapi.models.OpenAPI filter(org.eclipse.microprofile.openapi.OASFilter filter) {
        filter.filterOpenAPI(this);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.String getOpenapi() {
        return getProperty("openapi", java.lang.String.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setOpenapi(java.lang.String newValue) {
        setProperty("openapi", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.info.Info getInfo() {
        return getProperty("info", org.eclipse.microprofile.openapi.models.info.Info.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setInfo(org.eclipse.microprofile.openapi.models.info.Info newValue) {
        setProperty("info", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.servers.Server> getServers() {
        return getListProperty("servers");
    }

    /** {@inheritDoc} */
    @Override
    public void setServers(java.util.List<org.eclipse.microprofile.openapi.models.servers.Server> newValue) {
        setListProperty("servers", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addServer(org.eclipse.microprofile.openapi.models.servers.Server newValue) {
        addListPropertyEntry("servers", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeServer(org.eclipse.microprofile.openapi.models.servers.Server value) {
        removeListPropertyEntry("servers", value);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> getSecurity() {
        return getListProperty("security");
    }

    /** {@inheritDoc} */
    @Override
    public void setSecurity(java.util.List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> newValue) {
        setListProperty("security", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addSecurityRequirement(org.eclipse.microprofile.openapi.models.security.SecurityRequirement newValue) {
        addListPropertyEntry("security", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeSecurityRequirement(org.eclipse.microprofile.openapi.models.security.SecurityRequirement value) {
        removeListPropertyEntry("security", value);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.List<org.eclipse.microprofile.openapi.models.tags.Tag> getTags() {
        return getListProperty("tags");
    }

    /** {@inheritDoc} */
    @Override
    public void setTags(java.util.List<org.eclipse.microprofile.openapi.models.tags.Tag> newValue) {
        setListProperty("tags", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addTag(org.eclipse.microprofile.openapi.models.tags.Tag newValue) {
        addListPropertyEntry("tags", newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeTag(org.eclipse.microprofile.openapi.models.tags.Tag value) {
        removeListPropertyEntry("tags", value);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.Paths getPaths() {
        return getProperty("paths", org.eclipse.microprofile.openapi.models.Paths.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setPaths(org.eclipse.microprofile.openapi.models.Paths newValue) {
        setProperty("paths", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> getWebhooks() {
        return getMapProperty("webhooks");
    }

    /** {@inheritDoc} */
    @Override
    public void setWebhooks(java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> newValue) {
        setMapProperty("webhooks", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public AbstractOpenAPI addWebhook(String newKey, org.eclipse.microprofile.openapi.models.PathItem newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("webhooks", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeWebhook(String key) {
        removeMapPropertyEntry("webhooks", key);
    }

    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.Components getComponents() {
        return getProperty("components", org.eclipse.microprofile.openapi.models.Components.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setComponents(org.eclipse.microprofile.openapi.models.Components newValue) {
        setProperty("components", newValue);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(9);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(9);

        public Properties() {
            types.put("openapi", DataType.type(java.lang.String.class));
            minVersions.put("openapi", OpenApiVersion.V3_0);
            types.put("info", DataType.type(org.eclipse.microprofile.openapi.models.info.Info.class));
            minVersions.put("info", OpenApiVersion.V3_0);
            types.put("externalDocs", DataType.type(org.eclipse.microprofile.openapi.models.ExternalDocumentation.class));
            minVersions.put("externalDocs", OpenApiVersion.V3_0);
            types.put("servers", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.servers.Server.class)));
            minVersions.put("servers", OpenApiVersion.V3_0);
            types.put("security", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.security.SecurityRequirement.class)));
            minVersions.put("security", OpenApiVersion.V3_0);
            types.put("tags", DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.tags.Tag.class)));
            minVersions.put("tags", OpenApiVersion.V3_0);
            types.put("paths", DataType.type(org.eclipse.microprofile.openapi.models.Paths.class));
            minVersions.put("paths", OpenApiVersion.V3_0);
            types.put("webhooks", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.PathItem.class)));
            minVersions.put("webhooks", OpenApiVersion.V3_1);
            types.put("components", DataType.type(org.eclipse.microprofile.openapi.models.Components.class));
            minVersions.put("components", OpenApiVersion.V3_0);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
