package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-09-19T18:46:25.605407225Z")
public class Components
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.Components>
        implements org.eclipse.microprofile.openapi.models.Components {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.media.Schema> getSchemas() {
        return getMapProperty("schemas");
    }

    /** {@inheritDoc} */
    @Override
    public void setSchemas(java.util.Map<String, org.eclipse.microprofile.openapi.models.media.Schema> newValue) {
        setMapProperty("schemas", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addSchema(String newKey, org.eclipse.microprofile.openapi.models.media.Schema newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("schemas", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeSchema(String key) {
        removeMapPropertyEntry("schemas", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.responses.APIResponse> getResponses() {
        return getMapProperty("responses");
    }

    /** {@inheritDoc} */
    @Override
    public void setResponses(java.util.Map<String, org.eclipse.microprofile.openapi.models.responses.APIResponse> newValue) {
        setMapProperty("responses", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addResponse(String newKey, org.eclipse.microprofile.openapi.models.responses.APIResponse newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("responses", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeResponse(String key) {
        removeMapPropertyEntry("responses", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.parameters.Parameter> getParameters() {
        return getMapProperty("parameters");
    }

    /** {@inheritDoc} */
    @Override
    public void setParameters(java.util.Map<String, org.eclipse.microprofile.openapi.models.parameters.Parameter> newValue) {
        setMapProperty("parameters", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addParameter(String newKey, org.eclipse.microprofile.openapi.models.parameters.Parameter newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("parameters", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeParameter(String key) {
        removeMapPropertyEntry("parameters", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.examples.Example> getExamples() {
        return getMapProperty("examples");
    }

    /** {@inheritDoc} */
    @Override
    public void setExamples(java.util.Map<String, org.eclipse.microprofile.openapi.models.examples.Example> newValue) {
        setMapProperty("examples", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addExample(String newKey, org.eclipse.microprofile.openapi.models.examples.Example newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("examples", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeExample(String key) {
        removeMapPropertyEntry("examples", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.parameters.RequestBody> getRequestBodies() {
        return getMapProperty("requestBodies");
    }

    /** {@inheritDoc} */
    @Override
    public void setRequestBodies(java.util.Map<String, org.eclipse.microprofile.openapi.models.parameters.RequestBody> newValue) {
        setMapProperty("requestBodies", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addRequestBody(String newKey, org.eclipse.microprofile.openapi.models.parameters.RequestBody newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("requestBodies", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeRequestBody(String key) {
        removeMapPropertyEntry("requestBodies", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.headers.Header> getHeaders() {
        return getMapProperty("headers");
    }

    /** {@inheritDoc} */
    @Override
    public void setHeaders(java.util.Map<String, org.eclipse.microprofile.openapi.models.headers.Header> newValue) {
        setMapProperty("headers", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addHeader(String newKey, org.eclipse.microprofile.openapi.models.headers.Header newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("headers", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeHeader(String key) {
        removeMapPropertyEntry("headers", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.security.SecurityScheme> getSecuritySchemes() {
        return getMapProperty("securitySchemes");
    }

    /** {@inheritDoc} */
    @Override
    public void setSecuritySchemes(java.util.Map<String, org.eclipse.microprofile.openapi.models.security.SecurityScheme> newValue) {
        setMapProperty("securitySchemes", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addSecurityScheme(String newKey, org.eclipse.microprofile.openapi.models.security.SecurityScheme newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("securitySchemes", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeSecurityScheme(String key) {
        removeMapPropertyEntry("securitySchemes", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.links.Link> getLinks() {
        return getMapProperty("links");
    }

    /** {@inheritDoc} */
    @Override
    public void setLinks(java.util.Map<String, org.eclipse.microprofile.openapi.models.links.Link> newValue) {
        setMapProperty("links", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addLink(String newKey, org.eclipse.microprofile.openapi.models.links.Link newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("links", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeLink(String key) {
        removeMapPropertyEntry("links", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> getCallbacks() {
        return getMapProperty("callbacks");
    }

    /** {@inheritDoc} */
    @Override
    public void setCallbacks(java.util.Map<String, org.eclipse.microprofile.openapi.models.callbacks.Callback> newValue) {
        setMapProperty("callbacks", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addCallback(String newKey, org.eclipse.microprofile.openapi.models.callbacks.Callback newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("callbacks", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeCallback(String key) {
        removeMapPropertyEntry("callbacks", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> getPathItems() {
        return getMapProperty("pathItems");
    }

    /** {@inheritDoc} */
    @Override
    public void setPathItems(java.util.Map<String, org.eclipse.microprofile.openapi.models.PathItem> newValue) {
        setMapProperty("pathItems", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public Components addPathItem(String newKey, org.eclipse.microprofile.openapi.models.PathItem newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("pathItems", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removePathItem(String key) {
        removeMapPropertyEntry("pathItems", key);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(10);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(10);

        public Properties() {
            types.put("schemas", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
            minVersions.put("schemas", OpenApiVersion.V3_0);
            types.put("responses", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.responses.APIResponse.class)));
            minVersions.put("responses", OpenApiVersion.V3_0);
            types.put("parameters", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.parameters.Parameter.class)));
            minVersions.put("parameters", OpenApiVersion.V3_0);
            types.put("examples", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.examples.Example.class)));
            minVersions.put("examples", OpenApiVersion.V3_0);
            types.put("requestBodies", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.parameters.RequestBody.class)));
            minVersions.put("requestBodies", OpenApiVersion.V3_0);
            types.put("headers", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.headers.Header.class)));
            minVersions.put("headers", OpenApiVersion.V3_0);
            types.put("securitySchemes", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.security.SecurityScheme.class)));
            minVersions.put("securitySchemes", OpenApiVersion.V3_0);
            types.put("links", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.links.Link.class)));
            minVersions.put("links", OpenApiVersion.V3_0);
            types.put("callbacks", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.callbacks.Callback.class)));
            minVersions.put("callbacks", OpenApiVersion.V3_0);
            types.put("pathItems", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.PathItem.class)));
            minVersions.put("pathItems", OpenApiVersion.V3_1);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
