package io.smallrye.openapi.internal.models.media;

import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;

@javax.annotation.processing.Generated(value = "io.smallrye.openapi.model.apt.SmallRyeModelProcessor", date = "2025-09-19T18:46:25.597677599Z")
public class MediaType
        extends io.smallrye.openapi.model.BaseExtensibleModel<org.eclipse.microprofile.openapi.models.media.MediaType>
        implements org.eclipse.microprofile.openapi.models.media.MediaType {
    public static final PropertyMetadata PROPERTIES = new Properties();

    @Override
    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }


    /** {@inheritDoc} */
    @Override
    public org.eclipse.microprofile.openapi.models.media.Schema getSchema() {
        return getProperty("schema", org.eclipse.microprofile.openapi.models.media.Schema.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setSchema(org.eclipse.microprofile.openapi.models.media.Schema newValue) {
        setProperty("schema", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.lang.Object getExample() {
        return getProperty("example", java.lang.Object.class);
    }

    /** {@inheritDoc} */
    @Override
    public void setExample(java.lang.Object newValue) {
        setProperty("example", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.examples.Example> getExamples() {
        return getMapProperty("examples");
    }

    /** {@inheritDoc} */
    @Override
    public void setExamples(java.util.Map<String, org.eclipse.microprofile.openapi.models.examples.Example> newValue) {
        setMapProperty("examples", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public MediaType addExample(String newKey, org.eclipse.microprofile.openapi.models.examples.Example newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("examples", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeExample(String key) {
        removeMapPropertyEntry("examples", key);
    }

    /** {@inheritDoc} */
    @Override
    public java.util.Map<String, org.eclipse.microprofile.openapi.models.media.Encoding> getEncoding() {
        return getMapProperty("encoding");
    }

    /** {@inheritDoc} */
    @Override
    public void setEncoding(java.util.Map<String, org.eclipse.microprofile.openapi.models.media.Encoding> newValue) {
        setMapProperty("encoding", newValue);
    }

    /** {@inheritDoc} */
    @Override
    public MediaType addEncoding(String newKey, org.eclipse.microprofile.openapi.models.media.Encoding newValue) {
        java.util.Objects.requireNonNull(newKey, "Key must not be null");
        java.util.Objects.requireNonNull(newValue, "Value must not be null");
        putMapPropertyEntry("encoding", newKey, newValue);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public void removeEncoding(String key) {
        removeMapPropertyEntry("encoding", key);
    }

    public static class Properties implements io.smallrye.openapi.model.PropertyMetadata {

        private final java.util.Map<String, DataType> types = new java.util.HashMap<>(4);
        private final java.util.Map<String, OpenApiVersion> minVersions = new java.util.HashMap<>(4);

        public Properties() {
            types.put("schema", DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
            minVersions.put("schema", OpenApiVersion.V3_0);
            types.put("example", DataType.type(java.lang.Object.class));
            minVersions.put("example", OpenApiVersion.V3_0);
            types.put("examples", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.examples.Example.class)));
            minVersions.put("examples", OpenApiVersion.V3_0);
            types.put("encoding", DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Encoding.class)));
            minVersions.put("encoding", OpenApiVersion.V3_0);
        }

    @Override
        public DataType getPropertyType(String name) {
            if (types.containsKey(name)) {
                return types.get(name);
            } else {
                return DataType.type(Object.class);
            }
        }

        public OpenApiVersion getMinVersion(String name) {
            return minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}
