/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.gradleplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

public class GradleDependencyIndexCreator {
    private final Logger logger;

    public GradleDependencyIndexCreator(Logger logger) {
        this.logger = logger;
    }

    IndexView createIndex(Set<File> dependencies, FileCollection classesDirs) throws Exception {
        ArrayList<Map.Entry<File, Duration>> indexDurations = new ArrayList<Map.Entry<File, Duration>>();
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (File f : classesDirs.getFiles()) {
            indexes.add(this.indexModuleClasses(f));
        }
        for (File artifact : dependencies) {
            try {
                if (artifact.isDirectory()) {
                    indexes.add(this.indexModuleClasses(artifact));
                    continue;
                }
                if (!artifact.getName().endsWith(".jar")) continue;
                Index artifactIndex = this.logger.isDebugEnabled() ? this.timedIndex(indexDurations, artifact) : this.index(artifact);
                indexes.add(artifactIndex);
            }
            catch (IOException | ExecutionException e) {
                this.logger.error("Can't compute index of {}, skipping", (Object)artifact.getAbsolutePath(), (Object)e);
            }
        }
        this.printIndexDurations(indexDurations);
        return CompositeIndex.create(indexes);
    }

    private Index index(File artifact) throws IOException {
        Result result = JarIndexer.createJarIndex((File)artifact, (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
        return result.getIndex();
    }

    private void printIndexDurations(List<Map.Entry<File, Duration>> indexDurations) {
        if (this.logger.isDebugEnabled()) {
            indexDurations.sort(Map.Entry.comparingByValue());
            indexDurations.forEach(e -> {
                if (((Duration)e.getValue()).toMillis() > 25L) {
                    File artifact = (File)e.getKey();
                    this.logger.debug("Indexing took {} for {}", e.getValue(), (Object)artifact);
                }
            });
        }
    }

    private IndexView timedIndex(List<Map.Entry<File, Duration>> indexDurations, File artifact) throws Exception {
        LocalDateTime start = LocalDateTime.now();
        Index result = this.index(artifact);
        LocalDateTime end = LocalDateTime.now();
        Duration duration = Duration.between(start, end);
        indexDurations.add(new AbstractMap.SimpleEntry<File, Duration>(artifact, duration));
        return result;
    }

    private Index indexModuleClasses(ResolvedArtifact artifact) throws IOException {
        return this.indexModuleClasses(artifact.getFile());
    }

    private Index indexModuleClasses(File file) throws IOException {
        Indexer indexer = new Indexer();
        if (file.exists()) {
            try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
                List classFiles = stream.filter(path -> path.toString().endsWith(".class")).collect(Collectors.toList());
                for (Path path2 : classFiles) {
                    indexer.index(Files.newInputStream(path2, new OpenOption[0]));
                }
            }
        }
        return indexer.complete();
    }
}

