/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class JaxRsConstants {
    static final Set<DotName> APPLICATION = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.core.Application"), DotName.createSimple((String)"jakarta.ws.rs.core.Application")));
    static final Set<DotName> APPLICATION_PATH = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.ApplicationPath"), DotName.createSimple((String)"jakarta.ws.rs.ApplicationPath")));
    static final Set<DotName> PATH = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.Path"), DotName.createSimple((String)"jakarta.ws.rs.Path")));
    static final Set<DotName> PRODUCES = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.Produces"), DotName.createSimple((String)"jakarta.ws.rs.Produces")));
    static final Set<DotName> CONSUMES = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.Consumes"), DotName.createSimple((String)"jakarta.ws.rs.Consumes")));
    static final Set<DotName> EXCEPTION_MAPPER = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.ext.ExceptionMapper"), DotName.createSimple((String)"jakarta.ws.rs.ext.ExceptionMapper")));
    static final Set<DotName> QUERY_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.QueryParam"), DotName.createSimple((String)"jakarta.ws.rs.QueryParam")));
    static final Set<DotName> FORM_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.FormParam"), DotName.createSimple((String)"jakarta.ws.rs.FormParam")));
    static final Set<DotName> COOKIE_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.CookieParam"), DotName.createSimple((String)"jakarta.ws.rs.CookieParam")));
    static final Set<DotName> PATH_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.PathParam"), DotName.createSimple((String)"jakarta.ws.rs.PathParam")));
    static final Set<DotName> HEADER_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.HeaderParam"), DotName.createSimple((String)"jakarta.ws.rs.HeaderParam")));
    static final Set<DotName> MATRIX_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.MatrixParam"), DotName.createSimple((String)"jakarta.ws.rs.MatrixParam")));
    static final Set<DotName> BEAN_PARAM = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.BeanParam"), DotName.createSimple((String)"jakarta.ws.rs.BeanParam")));
    static final Set<DotName> ASYNC_RESPONSE = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.container.AsyncResponse"), DotName.createSimple((String)"jakarta.ws.rs.container.AsyncResponse")));
    static final Set<DotName> DEFAULT_VALUE = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.DefaultValue"), DotName.createSimple((String)"jakarta.ws.rs.DefaultValue")));
    static final Set<DotName> RESPONSE = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.core.Response"), DotName.createSimple((String)"jakarta.ws.rs.core.Response")));
    static final Set<DotName> PATH_SEGMENT = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.core.PathSegment"), DotName.createSimple((String)"jakarta.ws.rs.core.PathSegment")));
    static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)"org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
    static final Set<DotName> GET = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.GET"), DotName.createSimple((String)"jakarta.ws.rs.GET")));
    static final Set<DotName> PUT = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.PUT"), DotName.createSimple((String)"jakarta.ws.rs.PUT")));
    static final Set<DotName> POST = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.POST"), DotName.createSimple((String)"jakarta.ws.rs.POST")));
    static final Set<DotName> DELETE = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.DELETE"), DotName.createSimple((String)"jakarta.ws.rs.DELETE")));
    static final Set<DotName> HEAD = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.HEAD"), DotName.createSimple((String)"jakarta.ws.rs.HEAD")));
    static final Set<DotName> OPTIONS = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.OPTIONS"), DotName.createSimple((String)"jakarta.ws.rs.OPTIONS")));
    static final Set<DotName> PATCH = new TreeSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.ws.rs.PATCH"), DotName.createSimple((String)"jakarta.ws.rs.PATCH")));
    static final Set<DotName> CONTEXTS = Stream.of("javax", "jakarta").map(prefix -> DotName.createComponentized(null, (String)prefix)).map(prefix -> DotName.createComponentized((DotName)prefix, (String)"ws")).map(prefix -> DotName.createComponentized((DotName)prefix, (String)"rs")).map(prefix -> DotName.createComponentized((DotName)prefix, (String)"core")).flatMap(prefix -> Stream.of("Application", "UriInfo", "Request", "HttpHeaders", "SecurityContext").map(simpleName -> DotName.createComponentized((DotName)prefix, (String)simpleName))).collect(Collectors.toSet());
    static final String TO_RESPONSE_METHOD_NAME = "toResponse";
    private static final Set<DotName> methods = new LinkedHashSet<DotName>();
    public static final Set<DotName> HTTP_METHODS;
    private static final AnnotationValue[] EMPTY_VALUES;
    public static final Set<AnnotationInstance> HTTP_METHOD_INSTANCES;
    public static final Map<PathItem.HttpMethod, Set<DotName>> HTTP_METHOD_ANNOTATIONS;

    private JaxRsConstants() {
    }

    static {
        methods.addAll(GET);
        methods.addAll(PUT);
        methods.addAll(POST);
        methods.addAll(DELETE);
        methods.addAll(HEAD);
        methods.addAll(OPTIONS);
        methods.addAll(PATCH);
        HTTP_METHODS = Collections.unmodifiableSet(methods);
        EMPTY_VALUES = new AnnotationValue[0];
        HTTP_METHOD_INSTANCES = methods.stream().map(name -> AnnotationInstance.create((DotName)name, null, (AnnotationValue[])EMPTY_VALUES)).collect(Collectors.toUnmodifiableSet());
        EnumMap<PathItem.HttpMethod, Set<DotName>> annotations = new EnumMap<PathItem.HttpMethod, Set<DotName>>(PathItem.HttpMethod.class);
        annotations.put(PathItem.HttpMethod.DELETE, DELETE);
        annotations.put(PathItem.HttpMethod.GET, GET);
        annotations.put(PathItem.HttpMethod.HEAD, HEAD);
        annotations.put(PathItem.HttpMethod.OPTIONS, OPTIONS);
        annotations.put(PathItem.HttpMethod.PATCH, PATCH);
        annotations.put(PathItem.HttpMethod.POST, POST);
        annotations.put(PathItem.HttpMethod.PUT, PUT);
        HTTP_METHOD_ANNOTATIONS = Collections.unmodifiableMap(annotations);
    }
}

