/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.mavenplugin.MavenConfig;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

@Mojo(name="generate-schema", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSchemaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/", property="outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="openapi", property="schemaFilename")
    private String schemaFilename;
    @Parameter(defaultValue="compile,system", property="includeDependenciesScopes")
    private List<String> includeDependenciesScopes;
    @Parameter(defaultValue="jar", property="includeDependenciesTypes")
    private List<String> includeDependenciesTypes;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="classesDir")
    private File classesDir;
    @Parameter(property="configProperties")
    private File configProperties;
    @Parameter(property="modelReader")
    private String modelReader;
    @Parameter(property="filter")
    private String filter;
    @Parameter(property="scanDisabled")
    private Boolean scanDisabled;
    @Parameter(property="scanPackages")
    private String scanPackages;
    @Parameter(property="scanClasses")
    private String scanClasses;
    @Parameter(property="scanExcludePackages")
    private String scanExcludePackages;
    @Parameter(property="scanExcludeClasses")
    private String scanExcludeClasses;
    @Parameter(property="servers")
    private List<String> servers;
    @Parameter(property="pathServers")
    private List<String> pathServers;
    @Parameter(property="operationServers")
    private List<String> operationServers;
    @Parameter(property="scanDependenciesDisable")
    private Boolean scanDependenciesDisable;
    @Parameter(property="scanDependenciesJars")
    private List<String> scanDependenciesJars;
    @Parameter(property="schemaReferencesEnable")
    private Boolean schemaReferencesEnable;
    @Parameter(property="customSchemaRegistryClass")
    private String customSchemaRegistryClass;
    @Parameter(property="applicationPathDisable")
    private Boolean applicationPathDisable;
    @Parameter(property="openApiVersion")
    private String openApiVersion;
    @Parameter(property="infoTitle")
    private String infoTitle;
    @Parameter(property="infoVersion")
    private String infoVersion;
    @Parameter(property="infoDescription")
    private String infoDescription;
    @Parameter(property="infoTermsOfService")
    private String infoTermsOfService;
    @Parameter(property="infoContactEmail")
    private String infoContactEmail;
    @Parameter(property="infoContactName")
    private String infoContactName;
    @Parameter(property="infoContactUrl")
    private String infoContactUrl;
    @Parameter(property="infoLicenseName")
    private String infoLicenseName;
    @Parameter(property="infoLicenseUrl")
    private String infoLicenseUrl;
    @Parameter(property="operationIdStrategy")
    private String operationIdStrategy;
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";

    public void execute() throws MojoExecutionException {
        try {
            IndexView index = this.createIndex();
            OpenApiDocument schema = this.generateSchema(index);
            if (schema != null) {
                this.write(schema);
            } else {
                this.getLog().warn((CharSequence)"No Schema generated. Check that your code contains the MicroProfile OpenAPI Annotations");
            }
        }
        catch (IOException ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Could not generate OpenAPI Schema", (Exception)ex);
        }
    }

    private IndexView createIndex() throws MojoExecutionException {
        Index moduleIndex;
        try {
            moduleIndex = this.indexModuleClasses();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't compute index", (Exception)e);
        }
        if (!this.scanDependenciesDisable()) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            indexes.add(moduleIndex);
            for (Object a : this.mavenProject.getArtifacts()) {
                Artifact artifact = (Artifact)a;
                if (!this.includeDependenciesScopes.contains(artifact.getScope()) || !this.includeDependenciesTypes.contains(artifact.getType())) continue;
                try {
                    Result result = JarIndexer.createJarIndex((File)artifact.getFile(), (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
                    indexes.add(result.getIndex());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Can't compute index of " + artifact.getFile().getAbsolutePath() + ", skipping"), (Throwable)e);
                }
            }
            return CompositeIndex.create(indexes);
        }
        return moduleIndex;
    }

    private boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            return false;
        }
        return this.scanDependenciesDisable;
    }

    private Index indexModuleClasses() throws IOException {
        Indexer indexer = new Indexer();
        List classFiles = Files.walk(this.classesDir.toPath(), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".class")).collect(Collectors.toList());
        for (Path path2 : classFiles) {
            indexer.index(Files.newInputStream(path2, new OpenOption[0]));
        }
        return indexer.complete();
    }

    private OpenApiDocument generateSchema(IndexView index) throws IOException {
        MavenConfig openApiConfig = new MavenConfig(this.getProperties());
        OpenAPI staticModel = this.generateStaticModel();
        OpenAPI annotationModel = this.generateAnnotationModel(index, openApiConfig);
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        if (readerModel != null) {
            document.modelFromReader(readerModel);
        }
        if (staticModel != null) {
            document.modelFromStaticFile(staticModel);
        }
        document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        document.initialize();
        return document;
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, OpenApiConfig openApiConfig) {
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner(openApiConfig, indexView);
        return openApiAnnotationScanner.scan(new String[0]);
    }

    /*
     * Exception decompiling
     */
    private OpenAPI generateStaticModel() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Path getStaticFile() {
        Path classesPath = this.classesDir.toPath();
        if (Files.exists(classesPath, new LinkOption[0])) {
            Path resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_YML);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
            resourcePath = Paths.get(classesPath.toString(), WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
            if (Files.exists(resourcePath, new LinkOption[0])) {
                return resourcePath;
            }
        }
        return null;
    }

    private Format getFormat(Path path) {
        if (path.endsWith(".json")) {
            return Format.JSON;
        }
        return Format.YAML;
    }

    private Map<String, String> getProperties() throws IOException {
        HashMap<String, String> cp = new HashMap<String, String>();
        if (this.configProperties != null && this.configProperties.exists()) {
            Properties p = new Properties();
            try (InputStream is = Files.newInputStream(this.configProperties.toPath(), new OpenOption[0]);){
                p.load(is);
                cp.putAll(p);
            }
        }
        this.addToPropertyMap(cp, "mp.openapi.model.reader", this.modelReader);
        this.addToPropertyMap(cp, "mp.openapi.filter", this.filter);
        this.addToPropertyMap(cp, "mp.openapi.scan.disable", this.scanDisabled);
        this.addToPropertyMap(cp, "mp.openapi.scan.packages", this.scanPackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.classes", this.scanClasses);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.packages", this.scanExcludePackages);
        this.addToPropertyMap(cp, "mp.openapi.scan.exclude.classes", this.scanExcludeClasses);
        this.addToPropertyMap(cp, "mp.openapi.servers", this.servers);
        this.addToPropertyMap(cp, "mp.openapi.servers.path.", this.pathServers);
        this.addToPropertyMap(cp, "mp.openapi.servers.operation.", this.operationServers);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan-dependencies.disable", this.scanDependenciesDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.scan-dependencies.jars", this.scanDependenciesJars);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.schema-references.enable", this.schemaReferencesEnable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.custom-schema-registry.class", this.customSchemaRegistryClass);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.application-path.disable", this.applicationPathDisable);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.openapi", this.openApiVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.title", this.infoTitle);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.version", this.infoVersion);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.description", this.infoDescription);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.termsOfService", this.infoTermsOfService);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.email", this.infoContactEmail);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.name", this.infoContactName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.contact.url", this.infoContactUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.name", this.infoLicenseName);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.info.license.url", this.infoLicenseUrl);
        this.addToPropertyMap(cp, "mp.openapi.extensions.smallrye.operationIdStrategy", this.operationIdStrategy);
        return cp;
    }

    private void addToPropertyMap(Map<String, String> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void addToPropertyMap(Map<String, String> map, String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            map.put(key, values.stream().collect(Collectors.joining(",")));
        }
    }

    private void write(OpenApiDocument schema) throws MojoExecutionException {
        try {
            String yaml = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.YAML);
            String json = OpenApiSerializer.serialize((OpenAPI)schema.get(), (Format)Format.JSON);
            if (this.outputDirectory == null) {
                this.getLog().info((CharSequence)yaml);
            } else {
                Path directory = this.outputDirectory.toPath();
                if (!Files.exists(directory, new LinkOption[0])) {
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                this.writeSchemaFile(directory, this.schemaFilename + ".yaml", yaml.getBytes());
                this.writeSchemaFile(directory, this.schemaFilename + ".json", json.getBytes());
                this.getLog().info((CharSequence)("Wrote the schema files to " + this.outputDirectory.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write the result", (Exception)e);
        }
    }

    private void writeSchemaFile(Path directory, String filename, byte[] contents) throws IOException {
        Path file = Paths.get(directory.toString(), filename);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, contents, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

