/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

@Component(role=MavenDependencyIndexCreator.class, instantiationStrategy="singleton")
public class MavenDependencyIndexCreator {
    private final Cache<String, IndexView> indexCache = CacheBuilder.newBuilder().build();
    private final Set<String> ignoredArtifacts = new HashSet<String>();
    @Requirement
    private Logger logger;

    public MavenDependencyIndexCreator() {
        this.ignoredArtifacts.add("org.graalvm.sdk:graal-sdk");
        this.ignoredArtifacts.add("org.yaml:snakeyaml");
        this.ignoredArtifacts.add("org.wildfly.common:wildfly-common");
        this.ignoredArtifacts.add("com.fasterxml.jackson.core:jackson-core");
        this.ignoredArtifacts.add("com.fasterxml.jackson.core:jackson-databind");
        this.ignoredArtifacts.add("io.smallrye.reactive:smallrye-mutiny-vertx-core");
        this.ignoredArtifacts.add("commons-io:commons-io");
        this.ignoredArtifacts.add("io.smallrye.reactive:mutiny");
        this.ignoredArtifacts.add("org.jboss.narayana.jta:narayana-jta");
        this.ignoredArtifacts.add("org.glassfish.jaxb:jaxb-runtime");
        this.ignoredArtifacts.add("com.github.ben-manes.caffeine:caffeine");
        this.ignoredArtifacts.add("org.hibernate.validator:hibernate-validator");
        this.ignoredArtifacts.add("io.smallrye.config:smallrye-config-core");
        this.ignoredArtifacts.add("com.thoughtworks.xstream:xstream");
        this.ignoredArtifacts.add("com.github.javaparser:javaparser-core");
        this.ignoredArtifacts.add("org.jboss:jandex");
        this.ignoredArtifacts.add("org.jboss.resteasy:resteasy-core");
        this.ignoredArtifacts.add("antlr");
        this.ignoredArtifacts.add("io.netty");
        this.ignoredArtifacts.add("org.drools");
        this.ignoredArtifacts.add("net.bytebuddy");
        this.ignoredArtifacts.add("org.hibernate");
        this.ignoredArtifacts.add("org.kie");
        this.ignoredArtifacts.add("org.postgresql");
        this.ignoredArtifacts.add("org.apache.httpcomponents");
    }

    public IndexView createIndex(MavenProject mavenProject, boolean scanDependenciesDisable, List<String> includeDependenciesScopes, List<String> includeDependenciesTypes, List<String> includeStandardJavaModules) {
        Duration duration;
        LocalDateTime start;
        ArrayList<Map.Entry<Object, Duration>> indexDurations = new ArrayList<Map.Entry<Object, Duration>>();
        ArrayList<File> artifacts = new ArrayList<File>();
        String buildOutput = mavenProject.getBuild().getOutputDirectory();
        if (buildOutput != null) {
            this.logger.debug("Build output: " + buildOutput);
            artifacts.add(new File(buildOutput));
        } else {
            this.logger.warn("Build output is null!");
        }
        if (!scanDependenciesDisable) {
            mavenProject.getArtifacts().stream().filter(artifact -> !this.isIgnored((Artifact)artifact, includeDependenciesScopes, includeDependenciesTypes)).map(Artifact::getFile).filter(Objects::nonNull).forEach(artifacts::add);
        }
        ArrayList<Object> indexes = new ArrayList<Object>();
        if (includeStandardJavaModules != null) {
            for (String moduleName : includeStandardJavaModules) {
                start = LocalDateTime.now();
                indexes.add(this.indexJdkModule(moduleName));
                duration = Duration.between(start, LocalDateTime.now());
                indexDurations.add(new AbstractMap.SimpleEntry<CallSite, Duration>((CallSite)((Object)("module:" + moduleName)), duration));
            }
        }
        for (File artifact2 : artifacts) {
            try {
                if (artifact2.isDirectory()) {
                    start = LocalDateTime.now();
                    indexes.add(this.indexModuleClasses(artifact2));
                    duration = Duration.between(start, LocalDateTime.now());
                    indexDurations.add(new AbstractMap.SimpleEntry<File, Duration>(artifact2, duration));
                    continue;
                }
                if (!artifact2.getName().endsWith(".jar")) continue;
                IndexView artifactIndex = this.timeAndCache(indexDurations, artifact2, () -> {
                    Result result = JarIndexer.createJarIndex((File)artifact2, (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
                    return result.getIndex();
                });
                indexes.add(artifactIndex);
            }
            catch (Exception e) {
                this.logger.error("Can't compute index of " + artifact2.getAbsolutePath() + ", skipping", (Throwable)e);
            }
        }
        this.printIndexDurations(indexDurations);
        return CompositeIndex.create(indexes);
    }

    private void printIndexDurations(List<Map.Entry<Object, Duration>> indexDurations) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Indexed directories/artifacts for annotation scanning:");
            indexDurations.forEach(e -> this.logger.debug("  " + e.getKey() + " (index time " + e.getValue() + ")"));
        }
    }

    private boolean isIgnored(Artifact artifact, List<String> includeDependenciesScopes, List<String> includeDependenciesTypes) {
        if (artifact.getScope() == null && artifact.getFile() != null) {
            return false;
        }
        return !includeDependenciesScopes.contains(artifact.getScope()) || !includeDependenciesTypes.contains(artifact.getType()) || this.ignoredArtifacts.contains(artifact.getGroupId()) || this.ignoredArtifacts.contains(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    private IndexView timeAndCache(List<Map.Entry<Object, Duration>> indexDurations, File artifact, Callable<IndexView> callable) throws ExecutionException {
        LocalDateTime start = LocalDateTime.now();
        IndexView result = (IndexView)this.indexCache.get((Object)artifact.getAbsolutePath(), callable);
        LocalDateTime end = LocalDateTime.now();
        Duration duration = Duration.between(start, end);
        indexDurations.add(new AbstractMap.SimpleEntry<File, Duration>(artifact, duration));
        return result;
    }

    private Index indexJdkModule(String moduleName) {
        Indexer indexer = new Indexer();
        FileSystem jrt = FileSystems.getFileSystem(URI.create("jrt:/"));
        for (Path root : jrt.getRootDirectories()) {
            try {
                Stream<Path> walker = Files.walk(root, new FileVisitOption[0]);
                try {
                    walker.filter(path -> path.startsWith("/modules/" + moduleName)).filter(path -> path.getFileName().toString().endsWith(".class")).map(path -> {
                        try {
                            return Files.newInputStream(path, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }).forEach(stream -> {
                        try {
                            indexer.index(stream);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                finally {
                    if (walker == null) continue;
                    walker.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return indexer.complete();
    }

    private Index indexModuleClasses(File artifact) throws IOException {
        if (artifact.exists()) {
            try (Stream<Path> stream = Files.walk(artifact.toPath(), new FileVisitOption[0]);){
                File[] classFiles = (File[])stream.filter(path -> path.toString().endsWith(".class")).map(Path::toFile).toArray(File[]::new);
                Index index = Index.of((File[])classFiles);
                return index;
            }
        }
        this.logger.warn("Module directory does not exist: " + artifact);
        return Index.of(Collections.emptyList());
    }
}

