package io.smallrye.openapi.model;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ModelLogging_$logger extends DelegatingBasicLogger implements ModelLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModelLogging_$logger.class.getName();
    public ModelLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cylicReferenceDetected() {
        super.log.logf(FQCN, INFO, null, cylicReferenceDetected$str());
    }
    protected String cylicReferenceDetected$str() {
        return "SROAP10500: Cyclic object reference detected in OpenAPI model, skipping current node";
    }
    @Override
    public final void cylicReferenceAvoided(final String propertyName, final String typeName) {
        super.log.logf(FQCN, WARN, null, cylicReferenceAvoided$str(), propertyName, typeName);
    }
    protected String cylicReferenceAvoided$str() {
        return "SROAP10501: Merge of property would result in cyclic object reference in OpenAPI model, skipping property '%s' in type %s";
    }
}
