/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spring;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.spring.SpringLogging;
import io.smallrye.openapi.spring.SpringParameter;
import io.smallrye.openapi.spring.SpringParameterProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SpringAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String SPRING_PACKAGE = "org.springframework.web";

    public String getName() {
        return "Spring";
    }

    public boolean isWrapperType(Type type) {
        return type.name().equals((Object)SpringConstants.RESPONSE_ENTITY) && type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return false;
    }

    public boolean isPostMethod(MethodInfo method) {
        if (this.hasRequestMappingMethod(method, "POST")) {
            return true;
        }
        return method.hasAnnotation(SpringConstants.POST_MAPPING);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        if (this.hasRequestMappingMethod(method, "DELETE")) {
            return true;
        }
        return method.hasAnnotation(SpringConstants.DELETE_MAPPING);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return returnType.name().equals((Object)SpringConstants.RESPONSE_ENTITY) && !returnType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isMultipartOutput(Type returnType) {
        return SpringConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return SpringConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (SpringParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(SPRING_PACKAGE) && !instance.name().equals((Object)SpringConstants.REQUEST_BODY)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.processControllerClasses(context, openApi);
        boolean tagsDefined = openApi.getTags() != null && !openApi.getTags().isEmpty();
        this.sortTags(openApi, tagsDefined);
        this.sortPaths(openApi);
        return openApi;
    }

    private boolean hasRequestMappingMethod(MethodInfo method, String requestMethod) {
        if (method.hasAnnotation(SpringConstants.REQUEST_MAPPING)) {
            AnnotationInstance annotation = method.annotation(SpringConstants.REQUEST_MAPPING);
            AnnotationValue value = annotation.value("method");
            return value != null && value.asEnumArray().length > 0 && Arrays.asList(value.asEnumArray()).contains(requestMethod);
        }
        return false;
    }

    private void processControllerClasses(AnnotationScannerContext context, OpenAPI openApi) {
        Collection controllerAnnotations = context.getIndex().getAnnotations(SpringConstants.REST_CONTROLLER);
        ArrayList<ClassInfo> applications = new ArrayList<ClassInfo>();
        for (AnnotationInstance annotationInstance : controllerAnnotations) {
            if (annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                ClassInfo classInfo = annotationInstance.target().asClass();
                applications.add(classInfo);
                continue;
            }
            SpringLogging.log.ignoringAnnotation(SpringConstants.REST_CONTROLLER.withoutPackagePrefix());
        }
        this.processScannerExtensions(context, applications);
        for (ClassInfo controller : applications) {
            OpenAPI applicationOpenApi = this.processControllerClass(context, controller);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processControllerClass(AnnotationScannerContext context, ClassInfo controllerClass) {
        SpringLogging.log.processingController(controllerClass.simpleName());
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance requestMappingAnnotation = JandexUtil.getClassAnnotation((ClassInfo)controllerClass, (DotName)SpringConstants.REQUEST_MAPPING);
        this.currentAppPath = requestMappingAnnotation != null ? SpringParameterProcessor.requestMappingValuesToPath(requestMappingAnnotation) : "/";
        this.processDefinitionAnnotation(context, controllerClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(context, controllerClass, (OpenAPI)openApi);
        this.processServerAnnotation(controllerClass, (OpenAPI)openApi);
        this.processJavaSecurity(controllerClass, (OpenAPI)openApi);
        this.processControllerMethods(context, controllerClass, (OpenAPI)openApi, null);
        return openApi;
    }

    private void processControllerMethods(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags(context, (AnnotationTarget)resourceClass, openApi, false);
        for (MethodInfo methodInfo : this.getResourceMethods(context, resourceClass)) {
            String[] enumArray;
            AnnotationInstance requestMappingAnnotation;
            AnnotationValue methodValue;
            if (methodInfo.annotations().isEmpty()) continue;
            for (DotName validMethodAnnotations : SpringConstants.HTTP_METHODS) {
                if (!methodInfo.hasAnnotation(validMethodAnnotations)) continue;
                String toHttpMethod = this.toHttpMethod(validMethodAnnotations);
                PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)toHttpMethod);
                this.processControllerMethod(context, resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
            }
            if (!methodInfo.hasAnnotation(SpringConstants.REQUEST_MAPPING) || (methodValue = (requestMappingAnnotation = methodInfo.annotation(SpringConstants.REQUEST_MAPPING)).value("method")) == null) continue;
            for (String enumValue : enumArray = methodValue.asEnumArray()) {
                if (enumValue == null) continue;
                PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)enumValue.toUpperCase());
                this.processControllerMethod(context, resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
            }
        }
    }

    private String toHttpMethod(DotName dotname) {
        String className = dotname.withoutPackagePrefix();
        className = className.replace("Mapping", "");
        return className.toUpperCase();
    }

    private void processControllerMethod(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters) {
        SpringLogging.log.processingMethod(method.toString());
        CurrentScannerInfo.setCurrentConsumes((String[])SpringAnnotationScanner.getMediaTypes(method, "consumes", (String[])context.getConfig().getDefaultConsumes().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get())).orElse(null));
        CurrentScannerInfo.setCurrentProduces((String[])SpringAnnotationScanner.getMediaTypes(method, "produces", (String[])context.getConfig().getDefaultProduces().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get())).orElse(null));
        Optional maybeOperation = this.processOperation(context, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(context, method, openApi, resourceTags, operation);
        PathItemImpl pathItem = new PathItemImpl();
        Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
        ResourceParameters params = SpringParameterProcessor.process(context, resourceClass, method, reader, context.getExtensions());
        operation.setParameters(params.getOperationParameters());
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(context, method, operation, null);
        this.processSecurityRequirementAnnotation(resourceClass, method, operation);
        this.processCallback(context, method, operation);
        this.processServerAnnotation(method, operation);
        this.processExtensions(context, method, operation);
        JavaSecurityProcessor.processSecurityRoles((MethodInfo)method, (Operation)operation);
        this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
        String path = super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)openApi).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    static Optional<String[]> getMediaTypes(MethodInfo resourceMethod, String property, String[] defaultValue) {
        Set<DotName> annotationNames = SpringConstants.HTTP_METHODS;
        for (DotName annotationName : annotationNames) {
            AnnotationInstance annotation = resourceMethod.annotation(annotationName);
            if (annotation == null || annotation.value(property) == null) {
                annotation = JandexUtil.getClassAnnotation((ClassInfo)resourceMethod.declaringClass(), (DotName)SpringConstants.REQUEST_MAPPING);
            }
            if (annotation == null) continue;
            AnnotationValue annotationValue = annotation.value(property);
            if (annotationValue != null) {
                return Optional.of(annotationValue.asStringArray());
            }
            return Optional.of(defaultValue);
        }
        return Optional.empty();
    }
}

