/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spring;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.spring.SpringLogging;
import io.smallrye.openapi.spring.SpringParameter;
import io.smallrye.openapi.spring.SpringParameterProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class SpringAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String SPRING_PACKAGE = "org.springframework.web";

    public String getName() {
        return "Spring";
    }

    public boolean isWrapperType(Type type) {
        return type.name().equals((Object)SpringConstants.RESPONSE_ENTITY) && type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return false;
    }

    public boolean isPostMethod(MethodInfo method) {
        if (this.hasRequestMappingMethod(method, "POST")) {
            return true;
        }
        return method.hasAnnotation(SpringConstants.POST_MAPPING);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        if (this.hasRequestMappingMethod(method, "DELETE")) {
            return true;
        }
        return method.hasAnnotation(SpringConstants.DELETE_MAPPING);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return returnType.name().equals((Object)SpringConstants.RESPONSE_ENTITY) && !returnType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isMultipartOutput(Type returnType) {
        return SpringConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return SpringConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean isFrameworkContextType(Type type) {
        return SpringConstants.CONTEXTS.contains(type.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (SpringParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(SPRING_PACKAGE) && !instance.name().equals((Object)SpringConstants.REQUEST_BODY)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.context = context;
        this.processControllerClasses(openApi);
        return openApi;
    }

    private boolean hasRequestMappingMethod(MethodInfo method, String requestMethod) {
        if (method.hasAnnotation(SpringConstants.REQUEST_MAPPING)) {
            AnnotationInstance annotation = method.annotation(SpringConstants.REQUEST_MAPPING);
            AnnotationValue value = annotation.value("method");
            return value != null && value.asEnumArray().length > 0 && Arrays.asList(value.asEnumArray()).contains(requestMethod);
        }
        return false;
    }

    private void processControllerClasses(OpenAPI openApi) {
        Collection controllerAnnotations = this.context.getIndex().getAnnotations(SpringConstants.REST_CONTROLLER);
        ArrayList<ClassInfo> applications = new ArrayList<ClassInfo>();
        for (AnnotationInstance annotationInstance : controllerAnnotations) {
            if (annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                ClassInfo classInfo = annotationInstance.target().asClass();
                applications.add(classInfo);
                continue;
            }
            SpringLogging.log.ignoringAnnotation(SpringConstants.REST_CONTROLLER.withoutPackagePrefix());
        }
        this.processScannerExtensions(this.context, applications);
        for (ClassInfo controller : applications) {
            OpenAPI applicationOpenApi = this.processControllerClass(controller);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processControllerClass(ClassInfo controllerClass) {
        SpringLogging.log.processingController(controllerClass.simpleName());
        TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)controllerClass, null);
        this.context.getResolverStack().push(resolver);
        AnnotationInstance requestMappingAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)controllerClass, new DotName[]{SpringConstants.REQUEST_MAPPING});
        this.currentAppPath = requestMappingAnnotation != null ? SpringParameterProcessor.requestMappingValuesToPath(requestMappingAnnotation) : "/";
        OpenAPI openApi = this.processDefinitionAnnotation(this.context, controllerClass);
        this.processSecuritySchemeAnnotation(this.context, controllerClass, openApi);
        this.processServerAnnotation(this.context, controllerClass, openApi);
        this.processJavaSecurity(this.context, controllerClass, openApi);
        this.processControllerMethods(controllerClass, openApi, null);
        this.context.getResolverStack().pop();
        return openApi;
    }

    private void processControllerMethods(ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags(this.context, (AnnotationTarget)resourceClass, openApi, false);
        for (MethodInfo methodInfo : this.getResourceMethods(this.context, resourceClass)) {
            String[] enumArray;
            AnnotationInstance requestMappingAnnotation;
            AnnotationValue methodValue;
            if (methodInfo.annotations().isEmpty()) continue;
            for (DotName validMethodAnnotations : SpringConstants.HTTP_METHODS) {
                if (!methodInfo.hasAnnotation(validMethodAnnotations)) continue;
                String toHttpMethod = this.toHttpMethod(validMethodAnnotations);
                PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)toHttpMethod);
                this.processControllerMethod(resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
            }
            if (!methodInfo.hasAnnotation(SpringConstants.REQUEST_MAPPING) || (methodValue = (requestMappingAnnotation = methodInfo.annotation(SpringConstants.REQUEST_MAPPING)).value("method")) == null) continue;
            for (String enumValue : enumArray = methodValue.asEnumArray()) {
                if (enumValue == null) continue;
                PathItem.HttpMethod httpMethod = PathItem.HttpMethod.valueOf((String)enumValue.toUpperCase());
                this.processControllerMethod(resourceClass, methodInfo, httpMethod, openApi, tagRefs, locatorPathParameters);
            }
        }
    }

    private String toHttpMethod(DotName dotname) {
        String className = dotname.withoutPackagePrefix();
        className = className.replace("Mapping", "");
        return className.toUpperCase();
    }

    private void processControllerMethod(ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters) {
        SpringLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = this.getDefaultConsumes(this.context, method, this.getResourceParameters(resourceClass, method));
        this.context.setDefaultConsumes(defaultConsumes);
        this.context.setCurrentConsumes((String[])this.getMediaTypes(method, "consumes", defaultConsumes).orElse(null));
        String[] defaultProduces = this.getDefaultProduces(this.context, method);
        this.context.setDefaultProduces(defaultProduces);
        this.context.setCurrentProduces((String[])this.getMediaTypes(method, "produces", defaultProduces).orElse(null));
        Optional maybeOperation = this.processOperation(this.context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(this.context, method, openApi, resourceTags, operation);
        PathItem pathItem = OASFactory.createPathItem();
        ResourceParameters params = this.getResourceParameters(resourceClass, method);
        operation.setParameters(params.getOperationParameters());
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(this.context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(this.context, resourceClass, method, operation, null);
        this.processSecurityRequirementAnnotation(this.context, resourceClass, method, operation);
        this.processCallback(this.context, method, operation);
        this.processServerAnnotation(this.context, method, operation);
        this.processExtensions(this.context, method, operation);
        this.context.getJavaSecurityProcessor().processSecurityRoles(method, operation);
        pathItem.setOperation(methodType, operation);
        if (!SpringAnnotationScanner.processProfiles((OpenApiConfig)this.context.getConfig(), (Extensible)operation)) {
            return;
        }
        String path = super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)openApi).addPathItem(path, pathItem);
        } else {
            MergeUtil.mergeObjects((Constructible)existingPath, (Constructible)pathItem);
        }
    }

    private ResourceParameters getResourceParameters(ClassInfo resourceClass, MethodInfo method) {
        Function<AnnotationInstance, Parameter> reader = t -> this.context.io().parameterIO().read(t);
        return SpringParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
    }

    Optional<String[]> getMediaTypes(MethodInfo resourceMethod, String property, String[] defaultValue) {
        AnnotationValue annotationValue;
        HashSet<DotName> annotationNames = new HashSet<DotName>(SpringConstants.HTTP_METHODS);
        annotationNames.add(SpringConstants.REQUEST_MAPPING);
        for (DotName annotationName : annotationNames) {
            AnnotationValue annotationValue2;
            AnnotationInstance annotation = resourceMethod.annotation(annotationName);
            if (annotation == null || (annotationValue2 = annotation.value(property)) == null) continue;
            return Optional.of(annotationValue2.asStringArray());
        }
        AnnotationInstance annotation = this.context.annotations().getAnnotation((AnnotationTarget)resourceMethod.declaringClass(), new DotName[]{SpringConstants.REQUEST_MAPPING});
        if (annotation != null && (annotationValue = annotation.value(property)) != null) {
            return Optional.of(annotationValue.asStringArray());
        }
        return Optional.empty();
    }

    public boolean isRequestBody(MethodParameterInfo mip) {
        return mip.annotations().isEmpty() || this.context.annotations().hasAnnotation((AnnotationTarget)mip, new DotName[]{SpringConstants.REQUEST_BODY});
    }
}

