/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.CollectionStandin;
import io.smallrye.openapi.runtime.scanner.MapStandin;
import io.smallrye.openapi.runtime.scanner.dataobject.AnnotationTargetProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class OpenApiDataObjectScanner {
    private static final Logger LOG = Logger.getLogger(OpenApiDataObjectScanner.class);
    public static final Type OBJECT_TYPE = Type.create((DotName)DotName.createSimple((String)Object.class.getName()), (Type.Kind)Type.Kind.CLASS);
    public static final DotName COLLECTION_INTERFACE_NAME = DotName.createSimple((String)Collection.class.getName());
    public static final Type COLLECTION_TYPE = Type.create((DotName)COLLECTION_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName MAP_INTERFACE_NAME = DotName.createSimple((String)Map.class.getName());
    public static final Type MAP_TYPE = Type.create((DotName)MAP_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName ENUM_INTERFACE_NAME = DotName.createSimple((String)Enum.class.getName());
    public static final Type ENUM_TYPE = Type.create((DotName)ENUM_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
    public static final Type ARRAY_TYPE_OBJECT = ArrayType.create((DotName)DotName.createSimple((String)"[Ljava.lang.Object;"), (Type.Kind)Type.Kind.ARRAY);
    private Schema rootSchema;
    private AnnotationTarget rootAnnotationTarget;
    private final Type rootClassType;
    private final ClassInfo rootClassInfo;
    private final TypeUtil.TypeWithFormat rootClassTypeFormat;
    private final AugmentedIndexView index;
    private final DataObjectDeque objectStack;
    private final IgnoreResolver ignoreResolver;

    public OpenApiDataObjectScanner(IndexView _index, Type classType) {
        this.index = new AugmentedIndexView(_index);
        this.objectStack = new DataObjectDeque(this.index);
        this.ignoreResolver = new IgnoreResolver(this.index);
        this.rootClassType = classType;
        this.rootClassTypeFormat = TypeUtil.getTypeFormat(classType);
        this.rootSchema = new SchemaImpl();
        this.rootClassInfo = this.initialType(classType);
    }

    public OpenApiDataObjectScanner(IndexView _index, AnnotationTarget annotationTarget, Type classType) {
        this.index = new AugmentedIndexView(_index);
        this.objectStack = new DataObjectDeque(this.index);
        this.ignoreResolver = new IgnoreResolver(this.index);
        this.rootClassType = classType;
        this.rootClassTypeFormat = TypeUtil.getTypeFormat(classType);
        this.rootSchema = new SchemaImpl();
        this.rootClassInfo = this.initialType(classType);
        this.rootAnnotationTarget = annotationTarget;
    }

    public static Schema process(IndexView index, Type type) {
        return new OpenApiDataObjectScanner(index, type).process();
    }

    public static Schema process(PrimitiveType primitive) {
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(primitive);
        SchemaImpl primitiveSchema = new SchemaImpl();
        primitiveSchema.setType(typeFormat.getSchemaType());
        primitiveSchema.setFormat(typeFormat.getFormat().format());
        return primitiveSchema;
    }

    public Schema process() {
        LOG.debugv("Starting processing with root: {0}", (Object)this.rootClassType.name());
        if (this.isTerminalType(this.rootClassType)) {
            SchemaImpl simpleSchema = new SchemaImpl();
            simpleSchema.setType(this.rootClassTypeFormat.getSchemaType());
            simpleSchema.setFormat(this.rootClassTypeFormat.getFormat().format());
            return simpleSchema;
        }
        if (this.rootClassInfo == null && this.objectStack.isEmpty()) {
            return null;
        }
        DataObjectDeque.PathEntry root = this.objectStack.rootNode(this.rootAnnotationTarget, this.rootClassInfo, this.rootClassType, this.rootSchema);
        if (this.isSpecialType(this.rootClassType)) {
            this.resolveSpecial(root, this.rootClassType);
        } else {
            this.objectStack.push(root);
        }
        this.depthFirstGraphSearch();
        return this.rootSchema;
    }

    private void depthFirstGraphSearch() {
        while (!this.objectStack.isEmpty()) {
            DataObjectDeque.PathEntry currentPathEntry = this.objectStack.pop();
            ClassInfo currentClass = currentPathEntry.getClazz();
            Schema currentSchema = currentPathEntry.getSchema();
            Type currentType = currentPathEntry.getClazzType();
            currentPathEntry.setSchema(this.readKlass(currentClass, currentSchema));
            LOG.debugv("Getting all fields for: {0} in class: {1}", (Object)currentType, (Object)currentClass);
            Map<FieldInfo, TypeResolver> allFields = TypeResolver.getAllFields(this.index, currentType, currentClass);
            for (Map.Entry<FieldInfo, TypeResolver> entry : allFields.entrySet()) {
                FieldInfo field = entry.getKey();
                TypeResolver resolver = entry.getValue();
                if (Modifier.isStatic(field.flags()) || this.ignoreResolver.isIgnore((AnnotationTarget)field, currentPathEntry)) continue;
                LOG.debugv("Iterating field {0}", (Object)field);
                AnnotationTargetProcessor.process(this.index, this.objectStack, resolver, currentPathEntry, field);
            }
        }
    }

    private Schema readKlass(ClassInfo currentClass, Schema currentSchema) {
        AnnotationInstance annotation = TypeUtil.getSchemaAnnotation(currentClass);
        if (annotation != null) {
            return SchemaFactory.readSchema(this.index, currentSchema, annotation, Collections.emptyMap());
        }
        return currentSchema;
    }

    private void resolveSpecial(DataObjectDeque.PathEntry root, Type type) {
        Map<FieldInfo, TypeResolver> fieldResolution = TypeResolver.getAllFields(this.index, type, this.rootClassInfo);
        this.rootSchema = this.preProcessSpecial(type, fieldResolution.values().iterator().next(), root);
    }

    private Schema preProcessSpecial(Type type, TypeResolver typeResolver, DataObjectDeque.PathEntry currentPathEntry) {
        return AnnotationTargetProcessor.process(this.index, this.objectStack, typeResolver, currentPathEntry, type);
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.index, testSubject, test);
    }

    private boolean isTerminalType(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.WILDCARD_TYPE || type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.VOID) {
            return true;
        }
        TypeUtil.TypeWithFormat tf = TypeUtil.getTypeFormat(type);
        return tf.getSchemaType() != Schema.SchemaType.OBJECT && tf.getSchemaType() != Schema.SchemaType.ARRAY;
    }

    private boolean isSpecialType(Type type) {
        return this.isA(type, COLLECTION_TYPE) || this.isA(type, MAP_TYPE);
    }

    private ClassInfo initialType(Type type) {
        if (this.isA(type, COLLECTION_TYPE)) {
            return this.index.getClass(CollectionStandin.class);
        }
        if (this.isA(type, MAP_TYPE)) {
            return this.index.getClass(MapStandin.class);
        }
        return this.index.getClass(type);
    }
}

