/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class IgnoreResolver {
    private static final Logger LOG = Logger.getLogger(IgnoreResolver.class);
    private final Map<DotName, IgnoreAnnotationHandler> IGNORE_ANNOTATION_MAP = new LinkedHashMap<DotName, IgnoreAnnotationHandler>();
    private final AugmentedIndexView index;

    public IgnoreResolver(AugmentedIndexView index) {
        IgnoreAnnotationHandler[] ignoreHandlers;
        for (IgnoreAnnotationHandler handler : ignoreHandlers = new IgnoreAnnotationHandler[]{new JsonIgnorePropertiesHandler(), new JsonIgnoreHandler(), new JsonIgnoreTypeHandler()}) {
            this.IGNORE_ANNOTATION_MAP.put(handler.getName(), handler);
        }
        this.index = index;
    }

    public boolean isIgnore(AnnotationTarget annotationTarget, DataObjectDeque.PathEntry pathEntry) {
        for (IgnoreAnnotationHandler handler : this.IGNORE_ANNOTATION_MAP.values()) {
            boolean result = handler.shouldIgnore(annotationTarget, pathEntry);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean valueAsBooleanOrTrue(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value()).map(AnnotationValue::asBoolean).orElse(true);
    }

    private static interface IgnoreAnnotationHandler {
        public boolean shouldIgnore(AnnotationTarget var1, DataObjectDeque.PathEntry var2);

        public DotName getName();
    }

    private final class JsonIgnoreTypeHandler
    implements IgnoreAnnotationHandler {
        private Set<DotName> ignoredTypes = new LinkedHashSet<DotName>();

        private JsonIgnoreTypeHandler() {
        }

        @Override
        public boolean shouldIgnore(AnnotationTarget target, DataObjectDeque.PathEntry parentPathEntry) {
            if (target.kind() != AnnotationTarget.Kind.FIELD) {
                return false;
            }
            Type classType = target.asField().type();
            if (classType.kind() == Type.Kind.PRIMITIVE || classType.kind() == Type.Kind.VOID || !IgnoreResolver.this.index.containsClass(classType)) {
                return false;
            }
            ClassInfo classInfo = IgnoreResolver.this.index.getClass(classType);
            if (this.ignoredTypes.contains(classInfo.name())) {
                LOG.debugv("Ignoring type that is member of ignore set: {0}", (Object)classInfo.name());
                return true;
            }
            AnnotationInstance annotationInstance = TypeUtil.getAnnotation(classInfo, this.getName());
            if (annotationInstance != null && IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance)) {
                LOG.debugv("Ignoring type and adding to ignore set: {0}", (Object)classInfo.name());
                this.ignoredTypes.add(classInfo.name());
                return true;
            }
            return false;
        }

        @Override
        public DotName getName() {
            return DotName.createSimple((String)JsonIgnoreType.class.getName());
        }
    }

    private final class JsonIgnoreHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnoreHandler() {
        }

        @Override
        public boolean shouldIgnore(AnnotationTarget target, DataObjectDeque.PathEntry parentPathEntry) {
            AnnotationInstance annotationInstance = TypeUtil.getAnnotation(target, this.getName());
            if (annotationInstance != null) {
                return IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance);
            }
            return false;
        }

        @Override
        public DotName getName() {
            return DotName.createSimple((String)JsonIgnore.class.getName());
        }
    }

    private final class JsonIgnorePropertiesHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnorePropertiesHandler() {
        }

        @Override
        public boolean shouldIgnore(AnnotationTarget target, DataObjectDeque.PathEntry parentPathEntry) {
            if (target.kind() == AnnotationTarget.Kind.FIELD) {
                FieldInfo field = target.asField();
                return this.declaringClassIgnore(field) || this.nestingFieldIgnore(parentPathEntry.getAnnotationTarget(), field.name());
            }
            return false;
        }

        private boolean declaringClassIgnore(FieldInfo field) {
            AnnotationInstance declaringClassJIP = TypeUtil.getAnnotation(field.declaringClass(), this.getName());
            return this.shouldIgnoreTarget(declaringClassJIP, field.name());
        }

        private boolean nestingFieldIgnore(AnnotationTarget nesting, String fieldName) {
            if (nesting == null) {
                return false;
            }
            AnnotationInstance nestedTypeJIP = TypeUtil.getAnnotation(nesting, this.getName());
            return this.shouldIgnoreTarget(nestedTypeJIP, fieldName);
        }

        private boolean shouldIgnoreTarget(AnnotationInstance jipAnnotation, String targetName) {
            if (jipAnnotation == null || jipAnnotation.value() == null) {
                return false;
            }
            String[] jipValues = jipAnnotation.value().asStringArray();
            return Arrays.stream(jipValues).anyMatch(v -> v.equals(targetName));
        }

        @Override
        public DotName getName() {
            return DotName.createSimple((String)JsonIgnoreProperties.class.getName());
        }
    }
}

