/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;

public class TypeUtil {
    private static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final Type OBJECT_TYPE = Type.create((DotName)DOTNAME_OBJECT, (Type.Kind)Type.Kind.CLASS);
    private static final TypeWithFormat STRING_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.NONE);
    private static final TypeWithFormat BYTE_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.BYTE);
    private static final TypeWithFormat CHAR_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.BYTE);
    private static final TypeWithFormat NUMBER_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.NONE);
    private static final TypeWithFormat BIGDECIMAL_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.NONE);
    private static final TypeWithFormat DOUBLE_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.DOUBLE);
    private static final TypeWithFormat FLOAT_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.FLOAT);
    private static final TypeWithFormat BIGINTEGER_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.NONE);
    private static final TypeWithFormat INTEGER_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.INT32);
    private static final TypeWithFormat LONG_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.INT64);
    private static final TypeWithFormat SHORT_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.NONE);
    private static final TypeWithFormat BOOLEAN_FORMAT = new TypeWithFormat(Schema.SchemaType.BOOLEAN, DataFormat.NONE);
    private static final TypeWithFormat ARRAY_FORMAT = new TypeWithFormat(Schema.SchemaType.ARRAY, DataFormat.NONE);
    private static final TypeWithFormat OBJECT_FORMAT = new TypeWithFormat(Schema.SchemaType.OBJECT, DataFormat.NONE);
    private static final TypeWithFormat DATE_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.DATE);
    private static final TypeWithFormat DATE_TIME_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.DATE_TIME);
    private static final Map<DotName, TypeWithFormat> TYPE_MAP = new LinkedHashMap<DotName, TypeWithFormat>();

    private TypeUtil() {
    }

    public static TypeWithFormat getTypeFormat(PrimitiveType primitiveType) {
        return TYPE_MAP.get(primitiveType.name());
    }

    public static TypeWithFormat getTypeFormat(Type classType) {
        if (classType.kind() == Type.Kind.ARRAY) {
            return TypeUtil.arrayFormat();
        }
        return Optional.ofNullable(TYPE_MAP.get(TypeUtil.getName(classType))).orElse(TypeUtil.objectFormat());
    }

    public static TypeWithFormat arrayFormat() {
        return ARRAY_FORMAT;
    }

    public static TypeWithFormat objectFormat() {
        return OBJECT_FORMAT;
    }

    public static Class<?> getClass(Type type) throws ClassNotFoundException {
        return TypeUtil.getClass(TypeUtil.getName(type).toString());
    }

    public static Class<?> getClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
    }

    public static boolean isA(IndexView index, Type testSubject, Type testObject) {
        ClassInfo subJandexKlazz = index.getClassByName(TypeUtil.getName(testSubject));
        if (subJandexKlazz != null) {
            return subJandexKlazz.interfaceNames().contains(TypeUtil.getName(testObject)) || TypeUtil.hasSuper(index, subJandexKlazz, testObject);
        }
        try {
            Class<?> subjectKlazz = TypeUtil.getClass(testSubject);
            Class<?> objectKlazz = TypeUtil.getClass(testObject);
            return objectKlazz.isAssignableFrom(subjectKlazz);
        }
        catch (ClassNotFoundException nfe) {
            return false;
        }
    }

    private static boolean hasSuper(IndexView index, ClassInfo testSubject, Type testObject) {
        Type superKlazzType = testSubject.superClassType();
        while (superKlazzType != null) {
            if (TypeUtil.getName(superKlazzType).equals((Object)TypeUtil.getName(testObject))) {
                return true;
            }
            ClassInfo superKlazz = index.getClassByName(TypeUtil.getName(superKlazzType));
            if (superKlazz == null) {
                try {
                    Class<?> subjectKlazz = TypeUtil.getClass(testSubject.name().toString());
                    Class<?> objectKlazz = TypeUtil.getClass(testObject);
                    return objectKlazz.isAssignableFrom(subjectKlazz);
                }
                catch (ClassNotFoundException nfe) {
                    return false;
                }
            }
            superKlazzType = superKlazz.superClassType();
        }
        return false;
    }

    public static boolean isTerminalType(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.WILDCARD_TYPE || type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.VOID) {
            return true;
        }
        TypeWithFormat tf = TypeUtil.getTypeFormat(type);
        return tf.getSchemaType() != Schema.SchemaType.OBJECT && tf.getSchemaType() != Schema.SchemaType.ARRAY;
    }

    public static DotName getName(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return type.asArrayType().component().name();
        }
        if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            return TypeUtil.getBound(type.asWildcardType()).name();
        }
        return type.name();
    }

    public static Type getBound(WildcardType wct) {
        if (wct.extendsBound() != null) {
            return wct.extendsBound();
        }
        return OBJECT_TYPE;
    }

    public static Type resolveWildcard(WildcardType wildcardType) {
        return TypeUtil.getBound(wildcardType);
    }

    public static Type resolveWildcard(Type type) {
        if (type.kind() != Type.Kind.WILDCARD_TYPE) {
            return type;
        }
        return TypeUtil.getBound(type.asWildcardType());
    }

    public static boolean equalTypes(Type type1, Type type2) {
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return TypeUtil.equalWrappedTypes(type1, type2) || TypeUtil.equalWrappedTypes(type2, type1);
    }

    public static boolean equalWrappedTypes(Type primitiveCandidate, Type wrappedCandidate) {
        return primitiveCandidate.kind().equals((Object)Type.Kind.PRIMITIVE) && wrappedCandidate.kind().equals((Object)Type.Kind.CLASS) && TypeUtil.isPrimitiveWrapper(primitiveCandidate.asPrimitiveType(), wrappedCandidate);
    }

    public static boolean isPrimitiveWrapper(PrimitiveType primitive, Type wrapped) {
        Class wrapperType;
        switch (primitive.primitive()) {
            case BOOLEAN: {
                wrapperType = Boolean.class;
                break;
            }
            case BYTE: {
                wrapperType = Byte.class;
                break;
            }
            case CHAR: {
                wrapperType = Character.class;
                break;
            }
            case DOUBLE: {
                wrapperType = Double.class;
                break;
            }
            case FLOAT: {
                wrapperType = Float.class;
                break;
            }
            case INT: {
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                wrapperType = Long.class;
                break;
            }
            case SHORT: {
                wrapperType = Short.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive: " + primitive);
            }
        }
        return DotName.createSimple((String)wrapperType.getName()).equals((Object)wrapped.name());
    }

    public static AnnotationInstance getSchemaAnnotation(AnnotationTarget annotationTarget) {
        return TypeUtil.getAnnotation(annotationTarget, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(ClassInfo field) {
        return TypeUtil.getAnnotation(field, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(FieldInfo field) {
        return TypeUtil.getAnnotation(field, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(Type type) {
        return TypeUtil.getAnnotation(type, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static boolean hasAnnotation(AnnotationTarget target, DotName annotationName) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass().classAnnotation(annotationName) != null;
            }
            case FIELD: {
                return target.asField().hasAnnotation(annotationName);
            }
            case METHOD: {
                return target.asMethod().hasAnnotation(annotationName);
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).anyMatch(a -> a.name().equals((Object)annotationName));
            }
        }
        return false;
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName annotationName) {
        if (annotationTarget == null) {
            return null;
        }
        return TypeUtil.getAnnotations(annotationTarget).stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName) {
        return TypeUtil.getAnnotationValue(target, annotationName, "value", null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return TypeUtil.getAnnotationValue(target, annotationName, propertyName, null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName, T defaultValue) {
        AnnotationInstance annotation = TypeUtil.getAnnotation(target, annotationName);
        if (annotation != null) {
            return JandexUtil.value(annotation, propertyName);
        }
        return defaultValue;
    }

    public static Collection<AnnotationInstance> getAnnotations(AnnotationTarget type) {
        switch (type.kind()) {
            case CLASS: {
                return type.asClass().classAnnotations();
            }
            case FIELD: {
                return type.asField().annotations();
            }
            case METHOD: {
                return type.asMethod().annotations();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static ClassInfo getDeclaringClass(AnnotationTarget type) {
        switch (type.kind()) {
            case FIELD: {
                return type.asField().declaringClass();
            }
            case METHOD: {
                return type.asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().declaringClass();
            }
        }
        return null;
    }

    public static AnnotationInstance getAnnotation(Type type, DotName annotationName) {
        return type.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(ClassInfo field, DotName annotationName) {
        return field.classAnnotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(FieldInfo field, DotName annotationName) {
        return field.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    static {
        TYPE_MAP.put(DotName.createSimple((String)String.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuffer.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuilder.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)CharSequence.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.class.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.TYPE.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.class.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.TYPE.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Number.class.getName()), NUMBER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigDecimal.class.getName()), BIGDECIMAL_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.class.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.TYPE.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.class.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.TYPE.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigInteger.class.getName()), BIGINTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.class.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.TYPE.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.class.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.TYPE.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.class.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.TYPE.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.class.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.TYPE.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)java.util.Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDate.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDateTime.class.getName()), DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)ZonedDateTime.class.getName()), DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)OffsetDateTime.class.getName()), DATE_TIME_FORMAT);
    }

    public static enum DataFormat {
        NONE(null),
        INT32("int32"),
        INT64("int64"),
        FLOAT("float"),
        DOUBLE("double"),
        BYTE("byte"),
        BINARY("binary"),
        DATE("date"),
        DATE_TIME("date-time"),
        PASSWORD("password");

        private final String format;

        private DataFormat(String format) {
            this.format = format;
        }

        public String format() {
            return this.format;
        }

        public boolean hasFormat() {
            return this != NONE;
        }
    }

    public static final class TypeWithFormat {
        private final Schema.SchemaType schemaType;
        private final DataFormat format;

        public TypeWithFormat(@NotNull Schema.SchemaType schemaType, @NotNull DataFormat format) {
            this.schemaType = schemaType;
            this.format = format;
        }

        public Schema.SchemaType getSchemaType() {
            return this.schemaType;
        }

        public DataFormat getFormat() {
            return this.format;
        }
    }
}

