/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class TypeResolver {
    private static final Logger LOG = Logger.getLogger(TypeResolver.class);
    private static final Type BOOLEAN_TYPE = Type.create((DotName)DotName.createSimple((String)Boolean.class.getName()), (Type.Kind)Type.Kind.CLASS);
    private final Deque<Map<String, Type>> resolutionStack;
    private final String propertyName;
    private FieldInfo field;
    private MethodInfo readMethod;
    private MethodInfo writeMethod;
    private Type leaf;
    private static Comparator<AnnotationTarget> targetComparator = (t1, t2) -> {
        int result = TypeResolver.compareAnnotation(t1, t2, OpenApiConstants.DOTNAME_SCHEMA);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, OpenApiConstants.DOTNAME_JSONB_PROPERTY);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, OpenApiConstants.DOTNAME_JACKSON_PROPERTY);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, OpenApiConstants.DOTNAME_JAXB_XML_ELEMENT);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, OpenApiConstants.DOTNAME_JAXB_XML_ATTRIBUTE);
        if (result != 0) {
            return result;
        }
        if (t1.kind() == AnnotationTarget.Kind.FIELD) {
            return -1;
        }
        if (t2.kind() == AnnotationTarget.Kind.FIELD) {
            return 1;
        }
        if (t1.asMethod().name().startsWith("get") && !t2.asMethod().name().startsWith("get")) {
            return -1;
        }
        return 0;
    };
    private Queue<AnnotationTarget> targets = new PriorityQueue<AnnotationTarget>(targetComparator);

    private static int compareAnnotation(AnnotationTarget t1, AnnotationTarget t2, DotName annotationName) {
        boolean hasAnno1 = TypeUtil.hasAnnotation(t1, annotationName);
        boolean hasAnno2 = TypeUtil.hasAnnotation(t2, annotationName);
        if (hasAnno1) {
            if (!hasAnno2) {
                return -1;
            }
        } else if (hasAnno2) {
            return 1;
        }
        return 0;
    }

    private TypeResolver(String propertyName, FieldInfo field, Deque<Map<String, Type>> resolutionStack) {
        this.propertyName = propertyName;
        this.field = field;
        this.resolutionStack = resolutionStack;
        if (field != null) {
            this.leaf = field.type();
            this.targets.add((AnnotationTarget)field);
        } else {
            this.leaf = null;
        }
    }

    public ClassInfo getDeclaringClass() {
        return TypeUtil.getDeclaringClass(this.getAnnotationTarget());
    }

    public AnnotationTarget getAnnotationTarget() {
        return this.targets.peek();
    }

    public Type getUnresolvedType() {
        return this.leaf;
    }

    public String getPropertyName() {
        AnnotationTarget target = this.getAnnotationTarget();
        String name = (String)TypeUtil.getAnnotationValue(target, OpenApiConstants.DOTNAME_SCHEMA, "name");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, OpenApiConstants.DOTNAME_JSONB_PROPERTY, "value");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, OpenApiConstants.DOTNAME_JACKSON_PROPERTY, "value");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, OpenApiConstants.DOTNAME_JAXB_XML_ELEMENT, "name");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, OpenApiConstants.DOTNAME_JAXB_XML_ATTRIBUTE, "name");
        if (name != null) {
            return name;
        }
        return this.propertyName;
    }

    public FieldInfo getField() {
        return this.field;
    }

    private void setField(FieldInfo field) {
        this.field = field;
    }

    public MethodInfo getReadMethod() {
        return this.readMethod;
    }

    private void setReadMethod(MethodInfo readMethod) {
        if (this.readMethod != null) {
            this.targets.remove(this.readMethod);
        }
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.leaf = readMethod.returnType();
            this.targets.add((AnnotationTarget)readMethod);
        }
    }

    public MethodInfo getWriteMethod() {
        return this.writeMethod;
    }

    private void setWriteMethod(MethodInfo writeMethod) {
        if (this.writeMethod != null) {
            this.targets.remove(this.writeMethod);
        }
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.leaf = (Type)writeMethod.parameters().get(0);
            this.targets.add((AnnotationTarget)writeMethod);
        }
    }

    public Type resolveType() {
        return this.getResolvedType(this.leaf);
    }

    public Type getResolvedType(Type fieldType) {
        Type current = TypeUtil.resolveWildcard(fieldType);
        for (Map<String, Type> map : this.resolutionStack) {
            if (current.kind() == Type.Kind.TYPE_VARIABLE) {
                current = map.get(current.asTypeVariable().identifier());
                continue;
            }
            if (current.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
                current = map.get(current.asUnresolvedTypeVariable().identifier());
                continue;
            }
            return current;
        }
        return current;
    }

    public static Map<String, TypeResolver> getAllFields(AugmentedIndexView index, Type leaf, ClassInfo leafKlazz) {
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(index, leafKlazz, leaf);
        LinkedHashMap<String, TypeResolver> properties = new LinkedHashMap<String, TypeResolver>();
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                Map<String, Type> resMap = TypeResolver.buildParamTypeResolutionMap(currentClass, currentType.asParameterizedType());
                stack.push(resMap);
            }
            currentClass.fields().stream().filter(field -> TypeResolver.acceptField(field)).forEach(field -> TypeResolver.scanField(properties, field, stack));
            currentClass.methods().stream().filter(method -> TypeResolver.acceptMethod(method)).forEach(method -> TypeResolver.scanMethod(properties, method, stack));
            currentClass.interfaceTypes().stream().map(index::getClass).filter(Objects::nonNull).flatMap(clazz -> clazz.methods().stream()).forEach(method -> TypeResolver.scanMethod(properties, method, stack));
        }
        return TypeResolver.sorted(properties, chain.keySet());
    }

    private static boolean acceptMethod(MethodInfo method) {
        return !Modifier.isStatic(method.flags()) && !method.name().equals("getClass");
    }

    private static boolean acceptField(FieldInfo field) {
        return !Modifier.isStatic(field.flags());
    }

    private static void scanField(Map<String, TypeResolver> properties, FieldInfo field, Deque<Map<String, Type>> stack) {
        String propertyName = field.name();
        if (properties.containsKey(propertyName)) {
            TypeResolver resolver = properties.get(propertyName);
            if (resolver.getField() == null && (Modifier.isPublic(field.flags()) || Modifier.isProtected(field.flags()))) {
                resolver.setField(field);
            }
        } else {
            TypeResolver resolver = new TypeResolver(propertyName, field, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
    }

    private static void scanMethod(Map<String, TypeResolver> properties, MethodInfo method, Deque<Map<String, Type>> stack) {
        Type returnType = method.returnType();
        Type propertyType = null;
        if (TypeResolver.isAccessor(method)) {
            propertyType = returnType;
        } else if (TypeResolver.isMutator(method)) {
            propertyType = (Type)method.parameters().get(0);
        }
        if (propertyType != null) {
            TypeResolver.updateTypeResolvers(properties, stack, method, propertyType);
        }
    }

    private static void updateTypeResolvers(Map<String, TypeResolver> properties, Deque<Map<String, Type>> stack, MethodInfo method, Type propertyType) {
        TypeResolver resolver;
        int nameStart;
        String methodName = method.name();
        boolean isWriteMethod = TypeResolver.isMutator(method);
        if (isWriteMethod) {
            nameStart = 3;
        } else {
            int n = nameStart = methodName.startsWith("is") ? 2 : 3;
        }
        if (methodName.length() == nameStart) {
            return;
        }
        String propertyName = Character.toLowerCase(methodName.charAt(nameStart)) + methodName.substring(nameStart + 1);
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (!TypeUtil.equalTypes(resolver.getUnresolvedType(), propertyType)) {
                return;
            }
        } else {
            resolver = new TypeResolver(propertyName, null, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        if (isWriteMethod) {
            if (TypeResolver.isHigherPriority(method, resolver.getWriteMethod())) {
                resolver.setWriteMethod(method);
            }
        } else if (TypeResolver.isHigherPriority(method, resolver.getReadMethod())) {
            resolver.setReadMethod(method);
        }
    }

    private static boolean isAccessor(MethodInfo method) {
        Type returnType = method.returnType();
        if (!method.parameters().isEmpty() || Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        String methodName = method.name();
        if (methodName.startsWith("get")) {
            return true;
        }
        return methodName.startsWith("is") && TypeUtil.equalTypes(returnType, BOOLEAN_TYPE);
    }

    private static boolean isMutator(MethodInfo method) {
        Type returnType = method.returnType();
        if (method.parameters().size() != 1 || !Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        return method.name().startsWith("set");
    }

    private static boolean isHigherPriority(MethodInfo newMethod, MethodInfo oldMethod) {
        if (oldMethod == null) {
            return true;
        }
        if (Modifier.isInterface(newMethod.declaringClass().flags())) {
            return targetComparator.compare((AnnotationTarget)newMethod, (AnnotationTarget)oldMethod) < 0;
        }
        return false;
    }

    private static Map<String, TypeResolver> sorted(Map<String, TypeResolver> properties, Set<ClassInfo> chainKeys) {
        ArrayList<ClassInfo> chain = new ArrayList<ClassInfo>(chainKeys);
        Collections.reverse(chain);
        List order = chain.stream().map(TypeResolver::propertyOrder).flatMap(Collection::stream).collect(Collectors.toList());
        return properties.entrySet().stream().sorted((e1, e2) -> {
            int pIndex2;
            TypeResolver r1 = (TypeResolver)e1.getValue();
            TypeResolver r2 = (TypeResolver)e2.getValue();
            ClassInfo c1 = r1.getDeclaringClass();
            ClassInfo c2 = r2.getDeclaringClass();
            int pIndex1 = order.indexOf(r1.getPropertyName());
            if (pIndex1 < 0) {
                pIndex1 = order.indexOf(e1.getKey());
            }
            if ((pIndex2 = order.indexOf(r2.getPropertyName())) < 0) {
                pIndex2 = order.indexOf(e2.getKey());
            }
            if (pIndex1 > -1) {
                if (pIndex2 < 0) {
                    return -1;
                }
                return Integer.compare(pIndex1, pIndex2);
            }
            if (pIndex2 > -1) {
                return 1;
            }
            int cIndex1 = chain.indexOf(c1);
            int cIndex2 = chain.indexOf(c2);
            return Integer.compare(cIndex1, cIndex2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static List<String> propertyOrder(ClassInfo clazz) {
        AnnotationValue orderArray = null;
        AnnotationInstance propertyOrder = clazz.classAnnotation(OpenApiConstants.DOTNAME_JSONB_PROPERTY_ORDER);
        if (propertyOrder != null) {
            orderArray = propertyOrder.value();
        } else {
            propertyOrder = clazz.classAnnotation(OpenApiConstants.DOTNAME_JAXB_XML_TYPE);
            if (propertyOrder != null) {
                orderArray = propertyOrder.value("propOrder");
            } else {
                propertyOrder = clazz.classAnnotation(OpenApiConstants.DOTNAME_JACKSON_PROPERTY_ORDER);
                if (propertyOrder != null) {
                    orderArray = propertyOrder.value();
                }
            }
        }
        if (orderArray != null) {
            return Arrays.asList(orderArray.asStringArray());
        }
        return Collections.emptyList();
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, ParameterizedType parameterizedType) {
        List typeVariables = klazz.typeParameters();
        List arguments = parameterizedType.arguments();
        if (arguments.size() != typeVariables.size()) {
            LOG.errorv("Unanticipated mismatch between type arguments and type variables \nArgs: {0}\n Vars:{1}", (Object)arguments, (Object)typeVariables);
        }
        LinkedHashMap<String, Type> resolutionMap = new LinkedHashMap<String, Type>();
        for (int i = 0; i < arguments.size(); ++i) {
            TypeVariable typeVar = (TypeVariable)typeVariables.get(i);
            Type arg = (Type)arguments.get(i);
            resolutionMap.put(typeVar.identifier(), arg);
        }
        return resolutionMap;
    }
}

