/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class SchemaRegistry {
    private static ThreadLocal<SchemaRegistry> current = new ThreadLocal();
    private final OpenApiConfig config;
    private final OpenAPI oai;
    private Map<Type, GeneratedSchemaInfo> registry = new LinkedHashMap<Type, GeneratedSchemaInfo>();
    private Set<String> names = new LinkedHashSet<String>();

    public static SchemaRegistry newInstance(OpenApiConfig config, OpenAPI oai) {
        SchemaRegistry registry = new SchemaRegistry(config, oai);
        current.set(registry);
        return registry;
    }

    public static SchemaRegistry currentInstance() {
        return current.get();
    }

    public static Schema checkRegistration(IndexView index, Type entityType, TypeResolver typeResolver, Schema schema) {
        Type resolvedType = typeResolver.getResolvedType(entityType);
        switch (resolvedType.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: 
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                break;
            }
            default: {
                return schema;
            }
        }
        SchemaRegistry registry = SchemaRegistry.currentInstance();
        if (registry == null || !registry.schemaReferenceSupported()) {
            return schema;
        }
        if (registry.has(resolvedType)) {
            schema = registry.lookupRef(resolvedType);
        } else if (index.getClassByName(resolvedType.name()) != null) {
            schema = registry.register(resolvedType, schema);
        }
        return schema;
    }

    private SchemaRegistry(OpenApiConfig config, OpenAPI oai) {
        this.config = config;
        this.oai = oai;
    }

    public Schema register(Type entityType, Schema schema) {
        String localName;
        if (this.has(entityType)) {
            this.remove(entityType);
        }
        String name = localName = entityType.name().local();
        int idx = 1;
        while (this.names.contains(name)) {
            name = localName + idx++;
        }
        GeneratedSchemaInfo info = new GeneratedSchemaInfo();
        info.schema = schema;
        info.name = name;
        info.$ref = "#/components/schemas/" + name;
        this.registry.put(entityType, info);
        this.names.add(name);
        ModelUtil.components(this.oai).addSchema(name, schema);
        SchemaImpl rval = new SchemaImpl();
        rval.setRef(info.$ref);
        return rval;
    }

    public Schema lookup(Type instanceType) {
        GeneratedSchemaInfo info = this.registry.get(instanceType);
        if (info == null) {
            throw new NoSuchElementException("Class schema not registered: " + instanceType.name());
        }
        return info.schema;
    }

    public Schema lookupRef(Type instanceType) {
        GeneratedSchemaInfo info = this.registry.get(instanceType);
        if (info == null) {
            throw new NoSuchElementException("Class schema not registered: " + instanceType.name());
        }
        SchemaImpl rval = new SchemaImpl();
        rval.setRef(info.$ref);
        return rval;
    }

    public boolean has(Type instanceType) {
        return this.registry.containsKey(instanceType);
    }

    public Map<Type, GeneratedSchemaInfo> getSchemas() {
        return this.registry;
    }

    public boolean schemaReferenceSupported() {
        return this.config != null && this.config.schemaReferencesEnable();
    }

    private void remove(Type entityType) {
        this.registry.remove(entityType);
        this.names.remove(entityType.name().local());
    }

    static class GeneratedSchemaInfo {
        public String name;
        public Schema schema;
        public String $ref;

        GeneratedSchemaInfo() {
        }
    }
}

