/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.TypeUtil;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class TypeProcessor {
    private static final Logger LOG = Logger.getLogger(TypeProcessor.class);
    private final Schema schema;
    private final AugmentedIndexView index;
    private final AnnotationTarget annotationTarget;
    private final DataObjectDeque objectStack;
    private final TypeResolver typeResolver;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private Type type;

    public TypeProcessor(AugmentedIndexView index, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, Type type, Schema schema, AnnotationTarget annotationTarget) {
        this.objectStack = objectStack;
        this.typeResolver = typeResolver;
        this.parentPathEntry = parentPathEntry;
        this.type = type;
        this.schema = schema;
        this.index = index;
        this.annotationTarget = annotationTarget;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Type processType() {
        if (this.isTerminalType(this.type)) {
            return this.type;
        }
        if (this.type.kind() == Type.Kind.WILDCARD_TYPE) {
            this.type = TypeUtil.resolveWildcard(this.type.asWildcardType());
        }
        if (this.type.kind() == Type.Kind.ARRAY) {
            LOG.debugv("Processing an array {0}", (Object)this.type);
            ArrayType arrayType = this.type.asArrayType();
            SchemaImpl arrSchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(arrayType.component());
            arrSchema.setType(typeFormat.getSchemaType());
            arrSchema.setFormat(typeFormat.getFormat().format());
            if (!this.isTerminalType(arrayType.component()) && this.index.containsClass(this.type)) {
                this.pushToStack(this.type, arrSchema);
            }
            arrSchema = SchemaRegistry.checkRegistration(this.index, arrayType.component(), this.typeResolver, arrSchema);
            this.schema.items((Schema)arrSchema);
            return arrayType;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ENUM_TYPE) && this.index.containsClass(this.type)) {
            LOG.debugv("Processing an enum {0}", (Object)this.type);
            ClassInfo enumKlazz = this.index.getClass(this.type);
            for (FieldInfo enumField : enumKlazz.fields()) {
                if (enumField.name().endsWith("$VALUES") || !TypeUtil.getName(enumField.type()).equals((Object)enumKlazz.name())) continue;
                this.schema.addEnumeration((Object)enumField.name());
            }
            return OpenApiDataObjectScanner.STRING_TYPE;
        }
        if (this.type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.readParameterizedType(this.type.asParameterizedType());
        }
        if (this.type.kind() == Type.Kind.TYPE_VARIABLE || this.type.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
            return this.resolveTypeVariable(this.schema, this.type);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.COLLECTION_TYPE)) {
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.MAP_TYPE)) {
            return OpenApiDataObjectScanner.OBJECT_TYPE;
        }
        if (this.index.containsClass(this.type)) {
            this.pushToStack(this.type);
        } else {
            LOG.debugv("Encountered type not in Jandex index that is not well-known type. Will not traverse it: {0}", (Object)this.type);
        }
        return this.type;
    }

    private Type readParameterizedType(ParameterizedType pType) {
        LOG.debugv("Processing parameterized type {0}", (Object)pType);
        if (this.isA((Type)pType, OpenApiDataObjectScanner.COLLECTION_TYPE)) {
            LOG.debugv("Processing Java Collection. Will treat as an array.", new Object[0]);
            SchemaImpl arraySchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            Type arg = (Type)pType.arguments().get(0);
            if (this.isTerminalType(arg)) {
                TypeUtil.TypeWithFormat terminalType = TypeUtil.getTypeFormat(arg);
                arraySchema.type(terminalType.getSchemaType());
                arraySchema.format(terminalType.getFormat().format());
            } else {
                arraySchema = this.resolveParameterizedType(arg, arraySchema);
            }
            this.schema.items((Schema)arraySchema);
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA((Type)pType, OpenApiDataObjectScanner.MAP_TYPE)) {
            LOG.debugv("Processing Map. Will treat as an object.", new Object[0]);
            this.schema.type(Schema.SchemaType.OBJECT);
            if (pType.arguments().size() == 2) {
                Type valueType = (Type)pType.arguments().get(1);
                SchemaImpl propsSchema = new SchemaImpl();
                if (this.isTerminalType(valueType)) {
                    TypeUtil.TypeWithFormat tf = TypeUtil.getTypeFormat(valueType);
                    propsSchema.setType(tf.getSchemaType());
                    propsSchema.setFormat(tf.getFormat().format());
                } else {
                    propsSchema = this.resolveParameterizedType(valueType, propsSchema);
                }
                this.schema.additionalPropertiesSchema((Schema)propsSchema);
            }
            return OpenApiDataObjectScanner.OBJECT_TYPE;
        }
        this.pushToStack((Type)pType);
        return pType;
    }

    private Schema resolveParameterizedType(Type valueType, Schema propsSchema) {
        if (valueType.kind() == Type.Kind.TYPE_VARIABLE || valueType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || valueType.kind() == Type.Kind.WILDCARD_TYPE) {
            Type resolved = this.resolveTypeVariable(propsSchema, valueType);
            if (this.index.containsClass(resolved)) {
                propsSchema.type(Schema.SchemaType.OBJECT);
                propsSchema = SchemaRegistry.checkRegistration(this.index, valueType, this.typeResolver, propsSchema);
            }
        } else if (this.index.containsClass(valueType)) {
            propsSchema.type(Schema.SchemaType.OBJECT);
            this.pushToStack(valueType, propsSchema);
            propsSchema = SchemaRegistry.checkRegistration(this.index, valueType, this.typeResolver, propsSchema);
        }
        return propsSchema;
    }

    private Type resolveTypeVariable(Schema schema, Type fieldType) {
        Type resolvedType = this.typeResolver.getResolvedType(fieldType);
        LOG.debugv("Resolved type {0} -> {1}", (Object)fieldType, (Object)resolvedType);
        if (this.isTerminalType(resolvedType) || !this.index.containsClass(resolvedType)) {
            LOG.debugv("Is a terminal type {0}", (Object)resolvedType);
            TypeUtil.TypeWithFormat replacement = TypeUtil.getTypeFormat(resolvedType);
            schema.setType(replacement.getSchemaType());
            schema.setFormat(replacement.getFormat().format());
        } else {
            LOG.debugv("Attempting to do TYPE_VARIABLE substitution: {0} -> {1}", (Object)fieldType, (Object)resolvedType);
            if (this.index.containsClass(resolvedType)) {
                this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
            } else {
                LOG.debugv("Class for type {0} not available", (Object)resolvedType);
            }
        }
        return resolvedType;
    }

    private void pushToStack(Type fieldType) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, fieldType, this.schema);
    }

    private void pushToStack(Type resolvedType, Schema schema) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.index, testSubject, test);
    }

    private boolean isTerminalType(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.WILDCARD_TYPE || type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.VOID) {
            return true;
        }
        TypeUtil.TypeWithFormat tf = TypeUtil.getTypeFormat(type);
        return tf.getSchemaType() != Schema.SchemaType.OBJECT && tf.getSchemaType() != Schema.SchemaType.ARRAY;
    }
}

