/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ArchiveUtil {
    private static final Logger LOG = Logger.getLogger(ArchiveUtil.class);

    private ArchiveUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OpenApiConfig archiveToConfig(Archive<?> archive) {
        try (ShrinkWrapClassLoader cl = new ShrinkWrapClassLoader(new Archive[]{archive});){
            OpenApiConfigImpl openApiConfigImpl = new OpenApiConfigImpl(ConfigProvider.getConfig((ClassLoader)cl));
            return openApiConfigImpl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenApiStaticFile archiveToStaticFile(Archive<?> archive) {
        OpenApiStaticFile rval = new OpenApiStaticFile();
        rval.setFormat(OpenApiSerializer.Format.YAML);
        Node node = archive.get("/META-INF/openapi.yaml");
        if (node == null) {
            node = archive.get("/WEB-INF/classes/META-INF/openapi.yaml");
        }
        if (node == null) {
            node = archive.get("/META-INF/openapi.yml");
        }
        if (node == null) {
            node = archive.get("/WEB-INF/classes/META-INF/openapi.yml");
        }
        if (node == null) {
            node = archive.get("/META-INF/openapi.json");
            rval.setFormat(OpenApiSerializer.Format.JSON);
        }
        if (node == null) {
            node = archive.get("/WEB-INF/classes/META-INF/openapi.json");
            rval.setFormat(OpenApiSerializer.Format.JSON);
        }
        if (node == null) {
            return null;
        }
        rval.setContent(node.getAsset().openStream());
        return rval;
    }

    public static IndexView archiveToIndex(OpenApiConfig config, Archive<?> archive) {
        if (archive == null) {
            throw new RuntimeException("Archive was null!");
        }
        Indexer indexer = new Indexer();
        ArchiveUtil.index(indexer, "io/smallrye/openapi/runtime/scanner/CollectionStandin.class");
        ArchiveUtil.index(indexer, "io/smallrye/openapi/runtime/scanner/IterableStandin.class");
        ArchiveUtil.index(indexer, "io/smallrye/openapi/runtime/scanner/MapStandin.class");
        ArchiveUtil.indexArchive(config, indexer, archive);
        return indexer.complete();
    }

    private static void index(Indexer indexer, String resName) {
        ClassLoader cl = OpenApiAnnotationScanner.class.getClassLoader();
        try (InputStream klazzStream = cl.getResourceAsStream(resName);){
            indexer.index(klazzStream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private static void indexArchive(OpenApiConfig config, Indexer indexer, Archive<?> archive) {
        Map c = archive.getContent();
        try {
            for (Map.Entry each : c.entrySet()) {
                Throwable throwable;
                InputStream contentStream;
                ArchivePath archivePath = (ArchivePath)each.getKey();
                if (archivePath.get().endsWith(".class") && ArchiveUtil.acceptClassForScanning(config, archivePath.get())) {
                    contentStream = ((Node)each.getValue()).getAsset().openStream();
                    throwable = null;
                    try {
                        LOG.debugv("Indexing asset: {0} from archive: {1}", (Object)archivePath.get(), (Object)archive.getName());
                        indexer.index(contentStream);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (contentStream == null) continue;
                        if (throwable != null) {
                            try {
                                contentStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        contentStream.close();
                        continue;
                    }
                }
                if (!archivePath.get().endsWith(".jar") || !ArchiveUtil.acceptJarForScanning(config, archivePath.get())) continue;
                contentStream = ((Node)each.getValue()).getAsset().openStream();
                throwable = null;
                try {
                    JavaArchive jarArchive = (JavaArchive)((ZipImporter)((ZipImporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archivePath.get())).as(ZipImporter.class)).importFrom(contentStream)).as(JavaArchive.class);
                    ArchiveUtil.indexArchive(config, indexer, jarArchive);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean acceptJarForScanning(OpenApiConfig config, String jarName) {
        if (config.scanDependenciesDisable()) {
            return false;
        }
        Set<String> scanDependenciesJars = config.scanDependenciesJars();
        String nameOnly = new File(jarName).getName();
        return scanDependenciesJars.isEmpty() || scanDependenciesJars.contains(nameOnly);
    }

    private static boolean acceptClassForScanning(OpenApiConfig config, String archivePath) {
        boolean accept;
        if (archivePath == null) {
            return false;
        }
        Set<String> scanClasses = config.scanClasses();
        Set<String> scanPackages = config.scanPackages();
        Set<String> scanExcludeClasses = config.scanExcludeClasses();
        Set<String> scanExcludePackages = config.scanExcludePackages();
        if (scanClasses.isEmpty() && scanPackages.isEmpty() && scanExcludeClasses.isEmpty() && scanExcludePackages.isEmpty()) {
            return true;
        }
        if (archivePath.startsWith("/WEB-INF/classes/")) {
            archivePath = archivePath.substring("/WEB-INF/classes/".length());
        }
        String fqcn = archivePath.replaceAll("/", ".").substring(0, archivePath.lastIndexOf(".class"));
        String packageName = "";
        if (fqcn.startsWith(".")) {
            fqcn = fqcn.substring(1);
        }
        if (fqcn.contains(".")) {
            int idx = fqcn.lastIndexOf(".");
            packageName = fqcn.substring(0, idx);
        }
        if (scanClasses.isEmpty() && scanPackages.isEmpty()) {
            accept = true;
        } else if (!scanClasses.isEmpty() && scanPackages.isEmpty()) {
            accept = scanClasses.contains(fqcn);
        } else if (scanClasses.isEmpty() && !scanPackages.isEmpty()) {
            accept = scanPackages.contains(packageName);
        } else {
            boolean bl = accept = scanClasses.contains(fqcn) || scanPackages.contains(packageName);
        }
        if (!scanExcludeClasses.isEmpty() && scanExcludeClasses.contains(fqcn)) {
            accept = false;
        }
        if (!scanExcludePackages.isEmpty() && scanExcludePackages.contains(packageName)) {
            accept = false;
        }
        return accept;
    }
}

