/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.jaxrs2.server;

import io.opentracing.Tracer;
import io.smallrye.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.smallrye.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.smallrye.opentracing.contrib.jaxrs2.serialization.InterceptorSpanDecorator;
import io.smallrye.opentracing.contrib.jaxrs2.serialization.TracingInterceptor;
import java.util.List;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.InterceptorContext;

@Priority(value=4000)
public class ServerTracingInterceptor
extends TracingInterceptor {
    @Context
    private HttpServletRequest servletReq;

    public ServerTracingInterceptor(Tracer tracer, List<InterceptorSpanDecorator> spanDecorators) {
        super(tracer, spanDecorators);
    }

    @Override
    protected SpanWrapper findSpan(InterceptorContext context) {
        SpanWrapper spanWrapper = CastUtils.cast(context.getProperty(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
        if (spanWrapper == null && this.servletReq != null) {
            spanWrapper = CastUtils.cast(this.servletReq.getAttribute(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
        }
        return spanWrapper;
    }
}

