/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.jaxrs2.server;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;

public interface OperationNameProvider {
    public String operationName(ContainerRequestContext var1);

    public static class WildcardOperationName
    implements OperationNameProvider {
        private final String path;

        WildcardOperationName(String clazz, String method) {
            if (clazz.isEmpty() || clazz.charAt(0) != '/') {
                clazz = "/" + clazz;
            }
            if (clazz.endsWith("/")) {
                clazz = clazz.substring(0, clazz.length() - 1);
            }
            if (method.isEmpty() || method.charAt(0) != '/') {
                method = "/" + method;
            }
            this.path = clazz + method;
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            return requestContext.getMethod() + ":" + this.path;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.smallrye.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                String classPath = Builder.extractPath(clazz);
                String methodPath = Builder.extractPath(method);
                if (classPath == null || methodPath == null) {
                    for (Class<?> i : clazz.getInterfaces()) {
                        String intfPath;
                        if (classPath == null && (intfPath = Builder.extractPath(i)) != null) {
                            classPath = intfPath;
                        }
                        if (methodPath != null) continue;
                        for (Method m : i.getMethods()) {
                            if (m.getName() != method.getName() || !Arrays.deepEquals(m.getParameterTypes(), method.getParameterTypes())) continue;
                            methodPath = Builder.extractPath(m);
                        }
                    }
                }
                return new WildcardOperationName(classPath == null ? "" : classPath, methodPath == null ? "" : methodPath);
            }

            private static String extractPath(AnnotatedElement element) {
                Path path = element.getAnnotation(Path.class);
                if (path != null) {
                    return path.value();
                }
                return null;
            }
        }
    }

    public static class ClassNameOperationName
    implements OperationNameProvider {
        private String classMethod;

        ClassNameOperationName(Class<?> clazz, Method method) {
            this.classMethod = String.format("%s.%s", clazz.getName(), method.getName());
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            return String.format("%s:%s", requestContext.getMethod(), this.classMethod);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.smallrye.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                return new ClassNameOperationName(clazz, method);
            }
        }
    }

    public static class HTTPMethodOperationName
    implements OperationNameProvider {
        HTTPMethodOperationName() {
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            return requestContext.getMethod();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.smallrye.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                return new HTTPMethodOperationName();
            }
        }
    }

    public static interface Builder {
        public OperationNameProvider build(Class<?> var1, Method var2);
    }
}

