/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.jaxrs2.server;

import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.smallrye.opentracing.contrib.jaxrs2.serialization.InterceptorSpanDecorator;
import io.smallrye.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.smallrye.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.smallrye.opentracing.contrib.jaxrs2.server.ServerTracingFilter;
import io.smallrye.opentracing.contrib.jaxrs2.server.ServerTracingInterceptor;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.eclipse.microprofile.opentracing.Traced;

public class ServerTracingDynamicFeature
implements DynamicFeature {
    private static final Logger log = Logger.getLogger(ServerTracingDynamicFeature.class.getName());
    private final Builder builder;

    public ServerTracingDynamicFeature() {
        this(new Builder(GlobalTracer.get()));
    }

    private ServerTracingDynamicFeature(Builder builder) {
        this.builder = builder;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (!this.tracingDisabled(resourceInfo)) {
            this.log(resourceInfo);
            context.register((Object)new ServerTracingFilter(this.builder.tracer, this.operationName(resourceInfo), this.builder.spanDecorators, this.builder.operationNameBuilder.build(resourceInfo.getResourceClass(), resourceInfo.getResourceMethod()), this.builder.skipPattern != null ? Pattern.compile(this.builder.skipPattern) : null, this.builder.joinExistingActiveSpan), this.builder.priority);
            if (this.builder.traceSerialization) {
                context.register((Object)new ServerTracingInterceptor(this.builder.tracer, this.builder.serializationSpanDecorators), this.builder.serializationPriority);
            }
        }
    }

    private void log(ResourceInfo resourceInfo) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Registering tracing on %s#%s...", resourceInfo.getResourceClass().getCanonicalName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    protected Traced closestTracedAnnotation(ResourceInfo resourceInfo) {
        Traced tracedAnnotation = resourceInfo.getResourceMethod().getAnnotation(Traced.class);
        if (tracedAnnotation == null) {
            tracedAnnotation = resourceInfo.getResourceClass().getAnnotation(Traced.class);
        }
        return tracedAnnotation;
    }

    protected boolean tracingDisabled(ResourceInfo resourceInfo) {
        Traced traced = this.closestTracedAnnotation(resourceInfo);
        return traced == null ? !this.builder.allTraced : !traced.value();
    }

    protected String operationName(ResourceInfo resourceInfo) {
        Traced traced = this.closestTracedAnnotation(resourceInfo);
        return traced != null && !traced.operationName().isEmpty() ? traced.operationName() : null;
    }

    public static class Builder {
        private final Tracer tracer;
        private boolean allTraced;
        private List<ServerSpanDecorator> spanDecorators;
        private List<InterceptorSpanDecorator> serializationSpanDecorators;
        private int priority;
        private int serializationPriority;
        private OperationNameProvider.Builder operationNameBuilder;
        private boolean traceSerialization;
        private String skipPattern;
        private boolean joinExistingActiveSpan;

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.spanDecorators = Collections.singletonList(ServerSpanDecorator.STANDARD_TAGS);
            this.serializationSpanDecorators = Collections.singletonList(InterceptorSpanDecorator.STANDARD_TAGS);
            this.priority = 3000;
            this.serializationPriority = 4000;
            this.allTraced = true;
            this.operationNameBuilder = OperationNameProvider.WildcardOperationName.newBuilder();
            this.traceSerialization = true;
            this.joinExistingActiveSpan = false;
        }

        public Builder withTraceNothing() {
            this.allTraced = false;
            return this;
        }

        public Builder withDecorators(List<ServerSpanDecorator> spanDecorators) {
            this.spanDecorators = spanDecorators;
            return this;
        }

        public Builder withSerializationDecorators(List<InterceptorSpanDecorator> spanDecorators) {
            this.serializationSpanDecorators = spanDecorators;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withSerializationPriority(int serializationPriority) {
            this.serializationPriority = serializationPriority;
            return this;
        }

        public Builder withOperationNameProvider(OperationNameProvider.Builder builder) {
            this.operationNameBuilder = builder;
            return this;
        }

        public Builder withTraceSerialization(boolean traceSerialization) {
            this.traceSerialization = traceSerialization;
            return this;
        }

        public Builder withSkipPattern(String skipPattern) {
            this.skipPattern = skipPattern;
            return this;
        }

        public Builder withJoinExistingActiveSpan(boolean joinExistingActiveSpan) {
            this.joinExistingActiveSpan = joinExistingActiveSpan;
            return this;
        }

        public ServerTracingDynamicFeature build() {
            return new ServerTracingDynamicFeature(this);
        }
    }
}

