/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.restclient.tests.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Priority;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.util.Files;

@Priority(value=1)
public class SmallRyeBeanArchiveHandler
implements BeanArchiveHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BeanArchiveBuilder handle(String beanArchiveReference) {
        if ((beanArchiveReference = beanArchiveReference.substring(0, beanArchiveReference.lastIndexOf("/META-INF/beans.xml"))).endsWith(".war")) {
            return null;
        }
        try {
            URL url = new URL(beanArchiveReference);
            try (ZipInputStream in = this.openStream(url);){
                BeanArchiveBuilder builder = new BeanArchiveBuilder();
                this.handleLibrary(url, in, builder);
                BeanArchiveBuilder beanArchiveBuilder = builder;
                return beanArchiveBuilder;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    ZipInputStream openStream(URL url) throws IOException {
        InputStream in = url.openStream();
        return in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
    }

    private void handleLibrary(URL url, ZipInputStream zip, BeanArchiveBuilder builder) throws IOException {
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            if (!Files.isClass((String)entry.getName())) continue;
            builder.addClass(Files.filenameToClassname((String)entry.getName()));
        }
    }
}

