/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.ServiceInstance;
import io.smallrye.stork.ServiceInstancesCache;
import io.smallrye.stork.config.ServiceDiscoveryConfig;
import io.smallrye.stork.utils.DurationUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.List;

public abstract class CachingServiceDiscovery
implements ServiceDiscovery {
    private volatile ServiceInstancesCache cacheData;
    public Duration refreshPeriod;
    public static final Duration DEFAULT_REFRESH_INTERVAL = Duration.ofMinutes(5L);

    public CachingServiceDiscovery(ServiceDiscoveryConfig config) {
        String refreshPeriod = config.parameters().get("refresh-period");
        try {
            this.refreshPeriod = refreshPeriod != null ? DurationUtils.parseDuration(refreshPeriod) : DEFAULT_REFRESH_INTERVAL;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("refresh-period for service discovery should be a number, got: " + refreshPeriod, e);
        }
    }

    @Override
    public Uni<List<ServiceInstance>> getServiceInstances() {
        if (this.refreshNotNeed()) {
            return Uni.createFrom().item(this.cacheData.getServiceInstances());
        }
        Uni<List<ServiceInstance>> serviceInstances = this.fetchNewServiceInstances();
        return serviceInstances.onItem().invoke(services -> {
            this.cacheData = new ServiceInstancesCache((List<ServiceInstance>)services, LocalDateTime.now());
        });
    }

    public boolean refreshNotNeed() {
        return this.cacheData != null && this.cacheData.getLastFetchDateTime().isAfter(LocalDateTime.now().minus(this.refreshPeriod));
    }

    public abstract Uni<List<ServiceInstance>> fetchNewServiceInstances();
}

