/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.LoadBalancer;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.ServiceInstance;
import java.util.List;

public class Service {
    private final LoadBalancer loadBalancer;
    private final ServiceDiscovery serviceDiscovery;
    private final String serviceName;

    public Service(String serviceName, LoadBalancer loadBalancer, ServiceDiscovery serviceDiscovery) {
        this.loadBalancer = loadBalancer;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceName = serviceName;
    }

    public Uni<ServiceInstance> selectServiceInstance() {
        return this.serviceDiscovery.getServiceInstances().map(this.loadBalancer::selectServiceInstance);
    }

    public Uni<List<ServiceInstance>> getServiceInstances() {
        return this.serviceDiscovery.getServiceInstances();
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            throw new IllegalArgumentException("No load balancer for service '" + this.serviceName + "' defined");
        }
        return this.loadBalancer;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }
}

