/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.ServiceInstance;
import io.smallrye.stork.ServiceInstancesCache;
import io.smallrye.stork.config.ServiceDiscoveryConfig;
import io.smallrye.stork.utils.DurationUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(CachingServiceDiscovery.class);
    public final Duration refreshPeriod;
    public static final Duration DEFAULT_REFRESH_INTERVAL = Duration.ofMinutes(5L);
    private volatile ServiceInstancesCache cacheData;
    final AtomicReference<Refresh> refresh = new AtomicReference<Object>(null);

    public CachingServiceDiscovery(ServiceDiscoveryConfig config) {
        String period = config.parameters().get("refresh-period");
        try {
            this.refreshPeriod = period != null ? DurationUtils.parseDuration(period) : DEFAULT_REFRESH_INTERVAL;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("refresh-period for service discovery should be a number, got: " + period, e);
        }
    }

    @Override
    public Uni<List<ServiceInstance>> getServiceInstances() {
        if (this.cacheData == null) {
            Refresh previousRefresher = this.refresh.compareAndExchange(null, new Refresh());
            if (previousRefresher != null) {
                return previousRefresher.result();
            }
            Refresh refresh = this.refresh.get();
            refresh.trigger(() -> this.fetchNewServiceInstances(Collections.emptyList()));
            return refresh.result().onItem().invoke(this::replaceCacheData).onFailure().invoke(this::handleFetchError);
        }
        if (this.refreshNotNeed()) {
            return Uni.createFrom().item(this.cacheData.getServiceInstances());
        }
        Refresh previousRefresher = this.refresh.compareAndExchange(null, new Refresh());
        if (previousRefresher != null) {
            return previousRefresher.result();
        }
        Refresh refresh = this.refresh.get();
        refresh.trigger(() -> this.fetchNewServiceInstances(this.cacheData.getServiceInstances()));
        return refresh.result().onItem().invoke(this::replaceCacheData).onFailure().invoke(this::handleFetchError);
    }

    private void handleFetchError(Throwable error) {
        log.error("Failed to fetch service instances", error);
        this.refresh.set(null);
    }

    private void replaceCacheData(List<ServiceInstance> serviceInstances) {
        this.cacheData = new ServiceInstancesCache(serviceInstances, LocalDateTime.now());
        this.refresh.set(null);
    }

    public boolean refreshNotNeed() {
        return this.cacheData.getLastFetchDateTime().isAfter(LocalDateTime.now().minus(this.refreshPeriod));
    }

    public abstract Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> var1);

    public static class Refresh {
        final CompletableFuture<List<ServiceInstance>> result = new CompletableFuture();
        final Uni<List<ServiceInstance>> uniResult = Uni.createFrom().completionStage(this.result).memoize().indefinitely();

        protected void trigger(Supplier<Uni<List<ServiceInstance>>> supplier) {
            try {
                Uni<List<ServiceInstance>> instances = supplier.get();
                instances.subscribe().with(this.result::complete, this.result::completeExceptionally);
            }
            catch (Throwable any) {
                this.result.completeExceptionally(any);
            }
        }

        public Uni<List<ServiceInstance>> result() {
            return this.uniResult;
        }
    }
}

