/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.LoadBalancer;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.ServiceInstance;
import java.util.List;
import java.util.Optional;

public class Service {
    private final Optional<LoadBalancer> loadBalancer;
    private final ServiceDiscovery serviceDiscovery;
    private final String serviceName;
    private final boolean secure;

    public Service(String serviceName, Optional<LoadBalancer> loadBalancer, ServiceDiscovery serviceDiscovery, boolean secure) {
        this.loadBalancer = loadBalancer;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceName = serviceName;
        this.secure = secure;
    }

    public Uni<ServiceInstance> selectServiceInstance() {
        LoadBalancer loadBalancer = this.getLoadBalancer();
        return this.serviceDiscovery.getServiceInstances().map(loadBalancer::selectServiceInstance);
    }

    public Uni<List<ServiceInstance>> getServiceInstances() {
        return this.serviceDiscovery.getServiceInstances();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer.orElseThrow(() -> new IllegalArgumentException("No load balancer for service '" + this.serviceName + "' defined"));
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

