/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork;

import io.smallrye.stork.LoadBalancer;
import io.smallrye.stork.Service;
import io.smallrye.stork.ServiceDiscovery;
import io.smallrye.stork.config.ConfigProvider;
import io.smallrye.stork.config.LoadBalancerConfig;
import io.smallrye.stork.config.ServiceConfig;
import io.smallrye.stork.config.ServiceDiscoveryConfig;
import io.smallrye.stork.spi.ElementWithType;
import io.smallrye.stork.spi.LoadBalancerProvider;
import io.smallrye.stork.spi.ServiceDiscoveryProvider;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Stork {
    public static final String STORK = "stork";
    private static final Logger LOGGER = LoggerFactory.getLogger(Stork.class);
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private static final AtomicReference<Stork> REFERENCE = new AtomicReference();

    public Service getService(String serviceName) {
        Service service = this.services.get(serviceName);
        if (service == null) {
            throw new IllegalArgumentException("No service defined for name " + serviceName);
        }
        return service;
    }

    public Optional<Service> getServiceOptional(String serviceName) {
        Service service = this.services.get(serviceName);
        return Optional.ofNullable(service);
    }

    @Deprecated
    Stork() {
        Map<String, LoadBalancerProvider> loadBalancerProviders = this.getAll(LoadBalancerProvider.class);
        Map<String, ServiceDiscoveryProvider> serviceDiscoveryProviders = this.getAll(ServiceDiscoveryProvider.class);
        ServiceLoader<ConfigProvider> configs = ServiceLoader.load(ConfigProvider.class);
        Optional<ConfigProvider> highestPrioConfigProvider = configs.stream().map(ServiceLoader.Provider::get).max(Comparator.comparingInt(ConfigProvider::priority));
        ConfigProvider configProvider = highestPrioConfigProvider.orElseThrow(() -> new IllegalStateException("No SmallRye Stork ConfigProvider found"));
        for (ServiceConfig serviceConfig : configProvider.getConfigs()) {
            LoadBalancer loadBalancer;
            ServiceDiscoveryConfig serviceDiscoveryConfig = serviceConfig.serviceDiscovery();
            if (serviceDiscoveryConfig == null) {
                throw new IllegalArgumentException("No service discovery defined for service " + serviceConfig.serviceName());
            }
            String serviceDiscoveryType = serviceDiscoveryConfig.type();
            if (serviceDiscoveryType == null) {
                throw new IllegalArgumentException("Service discovery type not defined for service " + serviceConfig.serviceName());
            }
            ServiceDiscoveryProvider serviceDiscoveryProvider = serviceDiscoveryProviders.get(serviceDiscoveryType);
            if (serviceDiscoveryProvider == null) {
                throw new IllegalArgumentException("ServiceDiscoveryProvider not found for type " + serviceDiscoveryType);
            }
            ServiceDiscovery serviceDiscovery = serviceDiscoveryProvider.createServiceDiscovery(serviceDiscoveryConfig, serviceConfig.serviceName(), serviceConfig);
            LoadBalancerConfig loadBalancerConfig = serviceConfig.loadBalancer();
            if (loadBalancerConfig == null) {
                LOGGER.info("No load balancer configured for type " + serviceDiscoveryType);
                loadBalancer = null;
            } else {
                String loadBalancerType = loadBalancerConfig.type();
                LoadBalancerProvider loadBalancerProvider = loadBalancerProviders.get(loadBalancerType);
                if (loadBalancerProvider == null) {
                    throw new IllegalArgumentException("No LoadBalancerProvider for type " + loadBalancerType);
                }
                loadBalancer = loadBalancerProvider.createLoadBalancer(loadBalancerConfig, serviceDiscovery);
            }
            this.services.put(serviceConfig.serviceName(), new Service(serviceConfig.serviceName(), Optional.ofNullable(loadBalancer), serviceDiscovery, serviceConfig.secure()));
        }
    }

    private <T extends ElementWithType> Map<String, T> getAll(Class<T> providerClass) {
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        return providers.stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(ElementWithType::type, Function.identity()));
    }

    public static Stork getInstance() {
        return REFERENCE.get();
    }

    public static void shutdown() {
        REFERENCE.set(null);
    }

    public static void initialize() {
        REFERENCE.compareAndSet(null, new Stork());
    }
}

