/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.utils;

import io.smallrye.stork.utils.HostAndPort;

public final class StorkAddressUtils {
    public static HostAndPort parseToHostAndPort(String serviceAddress, int defaultPort, String serviceName) {
        if (serviceAddress == null || serviceAddress.isBlank()) {
            throw new IllegalArgumentException("Blank or null address: '" + serviceAddress + "'");
        }
        if (serviceAddress.charAt(0) == '[') {
            return StorkAddressUtils.parseIpV6AddressWithSquareBracket(serviceAddress, defaultPort, serviceName);
        }
        if (StorkAddressUtils.countColons(serviceAddress) > 1) {
            return new HostAndPort(serviceAddress, defaultPort);
        }
        return StorkAddressUtils.parseNonIpv6Adress(serviceAddress, defaultPort, serviceName);
    }

    private static HostAndPort parseNonIpv6Adress(String serviceAddress, int defaultPort, String serviceName) {
        String[] hostAndMaybePort = serviceAddress.split(":");
        switch (hostAndMaybePort.length) {
            case 1: {
                return new HostAndPort(serviceAddress, defaultPort);
            }
            case 2: {
                try {
                    int port = Integer.parseInt(hostAndMaybePort[1]);
                    return new HostAndPort(hostAndMaybePort[0], port);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(String.format("Invalid port '%s' in address '%s' for service '%s'", hostAndMaybePort[1], serviceAddress, serviceName), nfe);
                }
            }
        }
        throw new IllegalStateException(String.format("Unable to parse address '%s' to host and port for service '%s'", serviceAddress, serviceName));
    }

    private static HostAndPort parseIpV6AddressWithSquareBracket(String serviceAddress, int defaultPort, String serviceName) {
        int i;
        StringBuilder host = new StringBuilder();
        boolean done = false;
        for (i = 1; i < serviceAddress.length(); ++i) {
            if (serviceAddress.charAt(i) == ']') {
                done = true;
                break;
            }
            host.append(serviceAddress.charAt(i));
        }
        if (!done) {
            throw new IllegalArgumentException(String.format("IPv6 Address with a square bracket '[' does not have a matching closing square bracket ']' in address '%s' for service: '%s'", serviceAddress, serviceName));
        }
        if (++i == serviceAddress.length()) {
            return new HostAndPort(host.toString(), defaultPort);
        }
        if (serviceAddress.charAt(i) != ':') {
            throw new IllegalArgumentException(String.format("Unexpected character '%c' at character %d in address '%s' for service: '%s'", Character.valueOf(serviceAddress.charAt(i)), i, serviceAddress, serviceName));
        }
        int port = 0;
        ++i;
        while (i < serviceAddress.length()) {
            char c = serviceAddress.charAt(i);
            if (!StorkAddressUtils.isDigit(c)) {
                throw new IllegalArgumentException(String.format("Unexpected character '%c' while parsing port number in address '%s' for service '%s', at character %d, expected a digit", Character.valueOf(c), serviceName, serviceAddress, i));
            }
            port = 10 * port + (c - 48);
            ++i;
        }
        return new HostAndPort(host.toString(), port);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int countColons(String string) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++count;
        }
        return count;
    }
}

