/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.LoadBalancer;
import io.smallrye.stork.ServiceInstance;
import io.smallrye.stork.ServiceInstanceWithStatGathering;
import io.smallrye.stork.loadbalancer.leastresponsetime.CallStatistics;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.Collection;

public class LeastResponseTimeLoadBalancer
implements LoadBalancer {
    private static final int RETRY_AFTER_FAILURE_THRESHOLD = 10000;
    private static final long FORCE_RETRY_THRESHOLD = 1000L;
    private final CallStatistics callStatistics = new CallStatistics();

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        ServiceInstance best = null;
        CallStatistics.CallsData bestData = null;
        for (ServiceInstance instance : serviceInstances) {
            CallStatistics.CallsData callsData = this.callStatistics.statsForInstance(instance.getId());
            if (callsData == null) {
                callsData = this.callStatistics.init(instance.getId());
                callsData.forcedAttemptInProgress.set(true);
                best = instance;
                break;
            }
            if (bestData == null) {
                bestData = callsData;
                best = instance;
                continue;
            }
            if (this.timeToRetry(callsData)) {
                best = instance;
                break;
            }
            if (!this.isBetterThan(callsData, bestData)) continue;
            best = instance;
            bestData = callsData;
        }
        return new ServiceInstanceWithStatGathering(best, (CallStatisticsCollector)this.callStatistics);
    }

    private boolean isBetterThan(CallStatistics.CallsData callsData, CallStatistics.CallsData bestData) {
        if (bestData.lastSuccess != 0L) {
            if (callsData.lastSuccess == 0L) {
                return false;
            }
            long now = this.callStatistics.currentCall();
            return callsData.scaledTime() * (1.0 + callsData.scaledErrorCount(now - bestData.lastFailure)) <= bestData.scaledTime() * (1.0 + callsData.scaledErrorCount(now - callsData.lastFailure));
        }
        if (callsData.lastSuccess != 0L) {
            return true;
        }
        return callsData.lastFailure == 0L || callsData.lastFailure < bestData.lastFailure;
    }

    private boolean timeToRetry(CallStatistics.CallsData callsData) {
        if (callsData == null) {
            return true;
        }
        long now = this.callStatistics.currentCall();
        return now - callsData.lastFailure > 10000L && now - callsData.lastSuccess > 1000L && callsData.forcedAttemptInProgress.compareAndSet(false, true);
    }
}

