/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.stork.api.MetadataKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class Metadata<T extends Enum<T>> {
    private final EnumMap<T, Object> metatada;
    private final Class<T> clazz;
    private static final Metadata EMPTY = new Metadata<DefaultMetadataKey>(DefaultMetadataKey.class, Collections.emptyMap());

    private Metadata(Class<T> key, Map<T, Object> metatada) {
        if (metatada.isEmpty()) {
            this.metatada = new EnumMap(key);
            this.clazz = key;
        } else {
            this.metatada = new EnumMap<T, Object>(metatada);
            this.clazz = key;
        }
    }

    public static Metadata empty() {
        return EMPTY;
    }

    public static Metadata of(Class<?> key, Map<?, Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        return new Metadata(key, metadata);
    }

    public static Metadata of(Class<?> key) {
        if (key == null) {
            throw new IllegalArgumentException("`key` must not be `null`");
        }
        return new Metadata(key, Collections.emptyMap());
    }

    public Metadata with(T key, Object item) {
        if (key == null) {
            throw new IllegalArgumentException("`key` must not be `null`");
        }
        if (item == null) {
            throw new IllegalArgumentException(((Enum)key).name() + " should not be `null`");
        }
        EnumMap<T, Object> copy = new EnumMap<T, Object>(this.metatada);
        copy.put(key, item);
        return new Metadata<T>(this.clazz, copy);
    }

    public EnumMap<T, Object> getMetadata() {
        return this.metatada;
    }

    public static enum DefaultMetadataKey implements MetadataKey
    {
        GENERIC_METADATA_KEY("generic");

        private String name;

        private DefaultMetadataKey(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

