/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.spi.config;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import java.util.Collections;
import java.util.Map;

public class SimpleServiceConfig
implements ServiceConfig {
    private final String serviceName;
    private final ConfigWithType loadBalancerConfig;
    private final ConfigWithType ConfigWithType;

    private SimpleServiceConfig(String serviceName, ConfigWithType loadBalancerConfig, ConfigWithType ConfigWithType2) {
        this.serviceName = serviceName;
        this.loadBalancerConfig = loadBalancerConfig;
        this.ConfigWithType = ConfigWithType2;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public ConfigWithType loadBalancer() {
        return this.loadBalancerConfig;
    }

    @Override
    public ConfigWithType serviceDiscovery() {
        return this.ConfigWithType;
    }

    public static class SimpleServiceDiscoveryConfig
    implements ConfigWithType {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleServiceDiscoveryConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class SimpleLoadBalancerConfig
    implements ConfigWithType {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleLoadBalancerConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class Builder {
        String serviceName;
        ConfigWithType loadBalancerConfig;
        ConfigWithType ConfigWithType;
        boolean secure;

        public Builder setLoadBalancer(ConfigWithType loadBalancer) {
            this.loadBalancerConfig = loadBalancer;
            return this;
        }

        public Builder setServiceDiscovery(ConfigWithType serviceDiscovery) {
            this.ConfigWithType = serviceDiscovery;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public SimpleServiceConfig build() {
            return new SimpleServiceConfig(this.serviceName, this.loadBalancerConfig, this.ConfigWithType);
        }
    }
}

