/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.ServiceRegistrar;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;

public class Service {
    private final Semaphore instanceSelectionLock;
    private final LoadBalancer loadBalancer;
    private final ServiceDiscovery serviceDiscovery;
    private final ServiceRegistrar serviceRegistrar;
    private final String serviceName;

    public Service(String serviceName, LoadBalancer loadBalancer, ServiceDiscovery serviceDiscovery, ServiceRegistrar serviceRegistrar, boolean requiresStrictRecording) {
        this.loadBalancer = loadBalancer;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceRegistrar = serviceRegistrar;
        this.serviceName = serviceName;
        this.instanceSelectionLock = requiresStrictRecording ? new Semaphore(1) : null;
    }

    public Uni<ServiceInstance> selectInstance() {
        return this.serviceDiscovery.getServiceInstances().map(this::selectInstance);
    }

    public ServiceInstance selectInstance(Collection<ServiceInstance> instances) {
        return this.loadBalancer.selectServiceInstance(instances);
    }

    public Uni<ServiceInstance> selectInstanceAndRecordStart(boolean measureTime) {
        return this.serviceDiscovery.getServiceInstances().map(list -> this.selectInstanceAndRecordStart((Collection<ServiceInstance>)list, measureTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInstance selectInstanceAndRecordStart(Collection<ServiceInstance> instances, boolean measureTime) {
        if (this.instanceSelectionLock == null) {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            return result;
        }
        this.instanceSelectionLock.acquire();
        try {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            ServiceInstance serviceInstance = result;
            this.instanceSelectionLock.release();
            return serviceInstance;
        }
        catch (Throwable throwable) {
            try {
                this.instanceSelectionLock.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to lock for ServiceInstance selection", e);
            }
        }
    }

    public Uni<List<ServiceInstance>> getInstances() {
        return this.serviceDiscovery.getServiceInstances();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ServiceRegistrar getServiceRegistrar() {
        return this.serviceRegistrar;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

