/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.observability.ObservationCollector;
import io.smallrye.stork.api.observability.StorkObservation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;

public class Service {
    private final Semaphore instanceSelectionLock;
    private final LoadBalancer loadBalancer;
    private final ServiceDiscovery serviceDiscovery;
    private final ServiceRegistrar<?> serviceRegistrar;
    private final String serviceName;
    private final String serviceDiscoveryType;
    private final String serviceSelectionType;
    private final ObservationCollector observations;

    public Service(String serviceName, String serviceSelectionType, String serviceDiscoveryType, ObservationCollector collector, LoadBalancer loadBalancer, ServiceDiscovery serviceDiscovery, ServiceRegistrar<?> serviceRegistrar, boolean requiresStrictRecording) {
        this.loadBalancer = loadBalancer;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceRegistrar = serviceRegistrar;
        this.serviceDiscoveryType = serviceDiscoveryType;
        this.serviceSelectionType = serviceSelectionType;
        this.observations = collector;
        this.serviceName = serviceName;
        this.instanceSelectionLock = requiresStrictRecording ? new Semaphore(1) : null;
    }

    public Uni<ServiceInstance> selectInstance() {
        StorkObservation observationPoints = this.observations.create(this.serviceName, this.serviceDiscoveryType, this.serviceSelectionType);
        return this.serviceDiscovery.getServiceInstances().onItemOrFailure().invoke((list, failure) -> {
            if (failure != null) {
                observationPoints.onServiceDiscoveryFailure((Throwable)failure);
            } else {
                observationPoints.onServiceDiscoverySuccess((List<ServiceInstance>)list);
            }
        }).map(this::selectInstance).onItemOrFailure().invoke((selected, failure) -> {
            if (failure != null) {
                observationPoints.onServiceSelectionFailure((Throwable)failure);
            } else {
                observationPoints.onServiceSelectionSuccess(selected.getId());
            }
        });
    }

    public ServiceInstance selectInstance(Collection<ServiceInstance> instances) {
        return this.loadBalancer.selectServiceInstance(instances);
    }

    public Uni<ServiceInstance> selectInstanceAndRecordStart(boolean measureTime) {
        StorkObservation observationPoints = this.observations.create(this.serviceName, this.serviceDiscoveryType, this.serviceSelectionType);
        return this.serviceDiscovery.getServiceInstances().onItemOrFailure().invoke((list, failure) -> {
            if (failure != null) {
                observationPoints.onServiceDiscoveryFailure((Throwable)failure);
            } else {
                observationPoints.onServiceDiscoverySuccess((List<ServiceInstance>)list);
            }
        }).map(list -> this.selectInstanceAndRecordStart((Collection<ServiceInstance>)list, measureTime)).onItemOrFailure().invoke((selected, failure) -> {
            if (failure != null) {
                observationPoints.onServiceSelectionFailure((Throwable)failure);
            } else {
                observationPoints.onServiceSelectionSuccess(selected.getId());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInstance selectInstanceAndRecordStart(Collection<ServiceInstance> instances, boolean measureTime) {
        if (this.instanceSelectionLock == null) {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            return result;
        }
        this.instanceSelectionLock.acquire();
        try {
            ServiceInstance result = this.loadBalancer.selectServiceInstance(instances);
            if (result.gatherStatistics()) {
                result.recordStart(measureTime);
            }
            ServiceInstance serviceInstance = result;
            this.instanceSelectionLock.release();
            return serviceInstance;
        }
        catch (Throwable throwable) {
            try {
                this.instanceSelectionLock.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to lock for ServiceInstance selection", e);
            }
        }
    }

    public Uni<List<ServiceInstance>> getInstances() {
        return this.serviceDiscovery.getServiceInstances();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public ServiceRegistrar getServiceRegistrar() {
        return this.serviceRegistrar;
    }

    public ObservationCollector getObservations() {
        return this.observations;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

