/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AcmeConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public AcmeConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public AcmeConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "acme";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private AcmeConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new AcmeConfiguration(copy);
    }

    public String getHost() {
        return this.parameters.get("host");
    }

    public AcmeConfiguration withHost(String value) {
        return this.extend("host", value);
    }

    public String getPort() {
        return this.parameters.get("port");
    }

    public AcmeConfiguration withPort(String value) {
        return this.extend("port", value);
    }
}

