/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CachedAcmeConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public CachedAcmeConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public CachedAcmeConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "cached-acme";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private CachedAcmeConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new CachedAcmeConfiguration(copy);
    }

    public String getHost() {
        return this.parameters.get("host");
    }

    public CachedAcmeConfiguration withHost(String value) {
        return this.extend("host", value);
    }

    public String getPort() {
        return this.parameters.get("port");
    }

    public CachedAcmeConfiguration withPort(String value) {
        return this.extend("port", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public CachedAcmeConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }
}

