/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.CachedAcmeConfiguration;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.CachingServiceDiscovery;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.utils.ServiceInstanceIds;
import java.util.Collections;
import java.util.List;

public class CachedAcmeServiceDiscovery
extends CachingServiceDiscovery {
    private final String host;
    private final int port;

    public CachedAcmeServiceDiscovery(CachedAcmeConfiguration configuration) {
        super(configuration.getRefreshPeriod());
        this.host = configuration.getHost();
        this.port = Integer.parseInt(configuration.getPort());
    }

    public Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> previousInstances) {
        DefaultServiceInstance instance = new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), this.host, this.port, false);
        return Uni.createFrom().item(() -> Collections.singletonList(instance));
    }
}

