/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.smallrye.stork.Stork;
import io.smallrye.stork.api.ServiceDefinition;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.loadbalancer.random.RandomConfiguration;
import io.smallrye.stork.servicediscovery.staticlist.StaticConfiguration;
import io.smallrye.stork.servicediscovery.staticlist.StaticRegistrarConfiguration;
import java.time.Duration;

public class StorkApiExample {
    public static void main(String[] args) {
        Stork.initialize();
        Stork stork = Stork.getInstance();
        String example = "localhost:8080, localhost:8082";
        stork.defineIfAbsent("my-service", ServiceDefinition.of((ConfigWithType)new StaticConfiguration().withAddressList(example)));
        stork.defineIfAbsent("my-second-service", ServiceDefinition.of((ConfigWithType)new StaticConfiguration().withAddressList(example), (ConfigWithType)new RandomConfiguration()));
        ServiceInstance instance = (ServiceInstance)stork.getService("my-second-service").selectInstance().await().atMost(Duration.ofSeconds(1L));
        System.out.println(instance.getHost() + ":" + instance.getPort());
        stork.defineIfAbsent("my-third-service", ServiceDefinition.of((ConfigWithType)new StaticConfiguration().withAddressList(example), (ConfigWithType)new RandomConfiguration(), (ConfigWithType)new StaticRegistrarConfiguration()));
    }
}

