/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.ServiceInstanceWithStatGathering;
import io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeConfiguration;
import io.smallrye.stork.loadbalancer.leastresponsetime.impl.CallStatistics;
import io.smallrye.stork.loadbalancer.leastresponsetime.impl.util.FastPower;
import io.smallrye.stork.spi.CallStatisticsCollector;
import io.smallrye.stork.utils.DurationUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastResponseTimeLoadBalancer
implements LoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(LeastResponseTimeLoadBalancer.class);
    private final CallStatistics callStatistics;
    private final Random random;
    private final FastPower powersOfDecliningFactor;

    public LeastResponseTimeLoadBalancer(LeastResponseTimeConfiguration config) {
        long errorPenalty = DurationUtils.parseDuration((String)config.getErrorPenalty()).toNanos();
        double decliningFactor = Double.parseDouble(config.getDecliningFactor());
        this.powersOfDecliningFactor = new FastPower(decliningFactor);
        this.callStatistics = new CallStatistics(errorPenalty, this.powersOfDecliningFactor);
        this.random = Boolean.parseBoolean(config.getUseSecureRandom()) ? new SecureRandom() : new Random();
    }

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        ServiceInstance best = null;
        double bestScore = Double.MAX_VALUE;
        for (ServiceInstance instance : serviceInstances) {
            double score;
            CallStatistics.CallsData callsData = this.callStatistics.statsForInstance(instance.getId());
            if (callsData == null || callsData.lastRecorded == -2L) {
                log.debug("Selected: {} callsDataNull: {} lastRecorded: {}", new Object[]{instance.getId(), callsData == null, callsData == null ? null : Long.valueOf(callsData.lastRecorded)});
                this.callStatistics.init(instance.getId());
                best = instance;
                break;
            }
            if (callsData.lastRecorded == -1L || !((score = this.score(callsData)) < bestScore)) continue;
            best = instance;
            bestScore = score;
            log.debug("Current best: {}", (Object)instance.getId());
        }
        if (best == null) {
            int selectedIdx = this.random.nextInt(serviceInstances.size());
            best = serviceInstances instanceof List ? (ServiceInstance)((List)serviceInstances).get(selectedIdx) : new ArrayList<ServiceInstance>(serviceInstances).get(selectedIdx);
        }
        log.debug("Chosen service instance: {}", (Object)best.getId());
        return new ServiceInstanceWithStatGathering(best, (CallStatisticsCollector)this.callStatistics);
    }

    private double score(CallStatistics.CallsData callsData) {
        return callsData.scaledTime() * this.powersOfDecliningFactor.toPower(this.callStatistics.currentCall() - callsData.lastRecorded);
    }

    @Deprecated
    CallStatistics getCallStatistics() {
        return this.callStatistics;
    }
}

