package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeConfiguration;
import io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeLoadBalancerProvider
 */
 public class LeastResponseTimeLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeLoadBalancerProvider provider = new io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeLoadBalancerProvider();
   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeConfiguration typedConfig = new io.smallrye.stork.loadbalancer.leastresponsetime.LeastResponseTimeConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "least-response-time";
   }
}
