/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LeastResponseTimeConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public LeastResponseTimeConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public LeastResponseTimeConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "least-response-time";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private LeastResponseTimeConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new LeastResponseTimeConfiguration(copy);
    }

    public String getDecliningFactor() {
        String result = this.parameters.get("declining-factor");
        return result == null ? "0.9" : result;
    }

    public LeastResponseTimeConfiguration withDecliningFactor(String value) {
        return this.extend("declining-factor", value);
    }

    public String getErrorPenalty() {
        String result = this.parameters.get("error-penalty");
        return result == null ? "60s" : result;
    }

    public LeastResponseTimeConfiguration withErrorPenalty(String value) {
        return this.extend("error-penalty", value);
    }

    public String getUseSecureRandom() {
        String result = this.parameters.get("use-secure-random");
        return result == null ? "false" : result;
    }

    public LeastResponseTimeConfiguration withUseSecureRandom(String value) {
        return this.extend("use-secure-random", value);
    }
}

