/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime.impl;

import io.smallrye.stork.loadbalancer.leastresponsetime.impl.util.FastPower;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CallStatistics
implements CallStatisticsCollector {
    public static final int NO_CALL_STARTED = -2;
    public static final int CALL_STARTED = -1;
    private final AtomicLong callCount = new AtomicLong(1L);
    private final ConcurrentHashMap<Long, CallsData> storage = new ConcurrentHashMap();
    final long errorPenalty;
    final FastPower powersOfDecliningFactor;

    public CallStatistics(long errorPenalty, FastPower powersOfDecliningFactor) {
        this.errorPenalty = errorPenalty;
        this.powersOfDecliningFactor = powersOfDecliningFactor;
    }

    public void recordStart(long serviceInstanceId, boolean measureTime) {
        CallsData oldData = this.storage.get(serviceInstanceId);
        if (oldData == null) {
            throw new IllegalStateException("No CallsData initialized before starting to record data");
        }
        if (oldData.lastRecorded == -2L && measureTime) {
            CallsData newData = new CallsData(-1L, 0.0, 0.0);
            this.storage.replace(serviceInstanceId, oldData, newData);
        }
    }

    public void recordReply(long serviceInstanceId, long timeInNs) {
        long callIdx = this.callCount.incrementAndGet();
        this.storeTime(serviceInstanceId, timeInNs, callIdx);
    }

    public void recordEnd(long serviceInstanceId, Throwable error) {
        if (error != null) {
            long callIdx = this.callCount.get();
            this.storeTime(serviceInstanceId, this.errorPenalty, callIdx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeTime(long serviceInstanceId, long timeInNs, long callIdx) {
        while (true) {
            CallsData newData;
            CallsData oldData;
            if ((oldData = this.storage.get(serviceInstanceId)) != null) {
                double weightMultiplier = this.powersOfDecliningFactor.toPower(callIdx - oldData.lastRecorded);
                double newTotalTime = oldData.weightedTotalTime * weightMultiplier + (double)timeInNs;
                double newWeightSum = oldData.weightSum * weightMultiplier + 1.0;
                newData = new CallsData(callIdx, newTotalTime, newWeightSum);
                if (!this.storage.replace(serviceInstanceId, oldData, newData)) continue;
                return;
            }
            newData = new CallsData(callIdx, timeInNs, 1.0);
            if (this.storage.put(callIdx, newData) == null) return;
        }
    }

    public CallsData statsForInstance(long id) {
        return this.storage.get(id);
    }

    public long currentCall() {
        return this.callCount.get();
    }

    public void init(long id) {
        CallsData result = new CallsData(-2L, 0.0, 0.0);
        this.storage.put(id, result);
    }

    @Deprecated
    void clear() {
        this.callCount.set(0L);
        this.storage.clear();
    }

    public static class CallsData {
        public final long lastRecorded;
        public final double weightedTotalTime;
        public final double weightSum;

        private CallsData(long lastRecorded, double weighedTotalTime, double weightSum) {
            this.lastRecorded = lastRecorded;
            this.weightedTotalTime = weighedTotalTime;
            this.weightSum = weightSum;
        }

        public double scaledTime() {
            return this.weightedTotalTime / this.weightSum;
        }
    }
}

