/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.leastresponsetime.impl.util;

public class FastPower {
    final double base;
    final double[] baseToPowersOfTwo;

    public FastPower(double base) {
        this.base = base;
        this.baseToPowersOfTwo = new double[17];
        this.baseToPowersOfTwo[0] = base;
        for (int i = 1; i <= 16; ++i) {
            this.baseToPowersOfTwo[i] = this.baseToPowersOfTwo[i - 1] * this.baseToPowersOfTwo[i - 1];
        }
    }

    public double toPower(long exponent) {
        double result = 1.0;
        for (int i = 0; i <= 16; ++i) {
            int powerOf2 = 1 << i;
            if ((exponent & (long)powerOf2) == 0L) continue;
            result *= this.baseToPowersOfTwo[i];
        }
        return result;
    }
}

