package io.smallrye.stork.loadbalancer.poweroftwochoices;

import io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesConfiguration;
import io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider
 */
 @ApplicationScoped
 public class PowerOfTwoChoicesLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider provider;
   public PowerOfTwoChoicesLoadBalancerProviderLoader() {
       io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesLoadBalancerProvider();
       } 
       this.provider = actual;
   }

   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesConfiguration typedConfig = new io.smallrye.stork.loadbalancer.poweroftwochoices.PowerOfTwoChoicesConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "power-of-two-choices";
   }
}
